/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class GroupingHandlerAdd
extends AbstractAddStepHandler {
    public static final GroupingHandlerAdd INSTANCE = new GroupingHandlerAdd(GroupingHandlerDefinition.ATTRIBUTES);

    private GroupingHandlerAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : GroupingHandlerDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            if (hqServer.getGroupingHandler() != null) {
                throw new OperationFailedException(new ModelNode().set(MessagingLogger.ROOT_LOGGER.childResourceAlreadyExists("grouping-handler")));
            }
            if (context.isNormalServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        context.reloadRequired();
                        context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.stepCompleted();
        }
    }

    static void addGroupingHandlerConfig(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("grouping-handler")) {
            Property prop = model.get("grouping-handler").asProperty();
            String name = prop.getName();
            ModelNode node = prop.getValue();
            GroupingHandlerConfiguration.TYPE type = GroupingHandlerConfiguration.TYPE.valueOf((String)GroupingHandlerDefinition.TYPE.resolveModelAttribute(context, node).asString());
            String address = GroupingHandlerDefinition.GROUPING_HANDLER_ADDRESS.resolveModelAttribute(context, node).asString();
            int timeout = GroupingHandlerDefinition.TIMEOUT.resolveModelAttribute(context, node).asInt();
            long groupTimeout = GroupingHandlerDefinition.GROUP_TIMEOUT.resolveModelAttribute(context, node).asLong();
            long reaperPeriod = GroupingHandlerDefinition.REAPER_PERIOD.resolveModelAttribute(context, node).asLong();
            GroupingHandlerConfiguration conf = new GroupingHandlerConfiguration(SimpleString.toSimpleString((String)name), type, SimpleString.toSimpleString((String)address), timeout, groupTimeout, reaperPeriod);
            configuration.setGroupingHandlerConfiguration(conf);
        }
    }
}

