/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.HornetQService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

interface HornetQReloadRequiredHandlers {

    public static final class WriteAttributeHandler
    extends AbstractWriteAttributeHandler<Void> {
        public WriteAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            return HornetQService.isHornetQServiceInstalled(context, operation);
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.revertReloadRequired();
            }
        }
    }

    public static final class RemoveStepHandler
    extends AbstractRemoveStepHandler {
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.reloadRequired();
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.revertReloadRequired();
            }
        }
    }

    public static class AddStepHandler
    extends AbstractAddStepHandler {
        public AddStepHandler(AttributeDefinition ... attributes) {
            super(attributes);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.reloadRequired();
            }
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
            if (HornetQService.isHornetQServiceInstalled(context, operation)) {
                context.revertReloadRequired();
            }
        }
    }
}

