/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;

public abstract class AbstractJMSRuntimeHandler<T>
extends AbstractRuntimeOnlyHandler {
    private final Map<ResourceConfig, T> resources = Collections.synchronizedMap(new HashMap());

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean includeDefault;
        String opName = operation.require("operation").asString();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        T dataSource = this.getResourceConfig(address);
        boolean bl = includeDefault = operation.hasDefined("include-defaults") ? operation.get("include-defaults").asBoolean() : false;
        if (!"read-attribute".equals(opName)) {
            throw AbstractJMSRuntimeHandler.unknownOperation(opName);
        }
        String attributeName = operation.require("name").asString();
        this.executeReadAttribute(attributeName, context, dataSource, address, includeDefault);
        context.stepCompleted();
    }

    public void registerResource(String server, String name, T resource) {
        this.resources.put(new ResourceConfig(server, name), resource);
    }

    public void unregisterResource(String server, String name) {
        this.resources.remove(new ResourceConfig(server, name));
    }

    protected abstract void executeReadAttribute(String var1, OperationContext var2, T var3, PathAddress var4, boolean var5);

    private static IllegalStateException unknownOperation(String opName) {
        throw MessagingLogger.ROOT_LOGGER.operationNotValid(opName);
    }

    private T getResourceConfig(PathAddress operationAddress) throws OperationFailedException {
        String name = operationAddress.getLastElement().getValue();
        String server = operationAddress.getElement(operationAddress.size() - 2).getValue();
        T config = this.resources.get(new ResourceConfig(server, name));
        if (config == null) {
            String exceptionMessage = MessagingLogger.ROOT_LOGGER.noDestinationRegisteredForAddress(operationAddress);
            throw new OperationFailedException(new ModelNode().set(exceptionMessage));
        }
        return config;
    }

    private static final class ResourceConfig {
        private final String server;
        private final String name;

        private ResourceConfig(String server, String name) {
            this.name = name;
            this.server = server;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceConfig that = (ResourceConfig)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.server.equals(that.server);
        }

        public int hashCode() {
            int result = this.server.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

