/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DeprecatedAttributeWriteHandler;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.ConnectionFactoryReadAttributeHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryUpdateJndiHandler;
import org.jboss.as.messaging.jms.ConnectionFactoryWriteAttributeHandler;

public class ConnectionFactoryDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"connection-factory");
    public static final AttributeDefinition[] ATTRIBUTES = ConnectionFactoryDefinition.concat(ConnectionFactoryAttributes.Regular.ATTRIBUTES, ConnectionFactoryAttribute.getDefinitions(ConnectionFactoryAttributes.Common.ATTRIBUTES));
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{ConnectionFactoryAttributes.Common.ENTRIES, ConnectionFactoryAttributes.Regular.FACTORY_TYPE, CommonAttributes.HA, CommonAttributes.CALL_TIMEOUT, ConnectionFactoryAttributes.Common.AUTO_GROUP, ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND, ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND, ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT, ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD, CommonAttributes.CLIENT_ID, ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES, ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE, ConnectionFactoryAttributes.Common.CONNECTION_TTL, ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE, ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE, ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION, ConnectionFactoryAttributes.Common.GROUP_ID, ConnectionFactoryAttributes.Common.MAX_RETRY_INTERVAL, ConnectionFactoryAttributes.Common.MIN_LARGE_MESSAGE_SIZE, ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE, ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS, ConnectionFactoryAttributes.Common.RETRY_INTERVAL, ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER, ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE, ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS};
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{ConnectionFactoryAttributes.Regular.INITIAL_MESSAGE_PACKET_SIZE};
    private final boolean registerRuntimeOnly;

    static final AttributeDefinition[] concat(AttributeDefinition[] common, AttributeDefinition ... specific) {
        int size = common.length + specific.length;
        AttributeDefinition[] result = new AttributeDefinition[size];
        System.arraycopy(common, 0, result, 0, common.length);
        System.arraycopy(specific, 0, result, common.length, specific.length);
        return result;
    }

    public ConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory"), (OperationStepHandler)ConnectionFactoryAdd.INSTANCE, (OperationStepHandler)ConnectionFactoryRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr == ConnectionFactoryAttributes.Common.DISCOVERY_INITIAL_WAIT_TIMEOUT || attr == ConnectionFactoryAttributes.Common.FAILOVER_ON_SERVER_SHUTDOWN) {
                registry.registerReadWriteAttribute(attr, null, DeprecatedAttributeWriteHandler.INSTANCE);
                continue;
            }
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)ConnectionFactoryWriteAttributeHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)ConnectionFactoryReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ConnectionFactoryUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

