/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSQueueConfigurationWriteHandler;
import org.jboss.as.messaging.jms.JMSQueueControlHandler;
import org.jboss.as.messaging.jms.JMSQueueReadAttributeHandler;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.messaging.jms.JMSQueueUpdateJndiHandler;
import org.jboss.dmr.ModelType;

public class JMSQueueDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"jms-queue");
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES, CommonAttributes.SELECTOR, CommonAttributes.DURABLE};
    static final AttributeDefinition QUEUE_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"queue-address", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition DEAD_LETTER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"dead-letter-address", (ModelType)ModelType.STRING).setAllowNull(true)).setStorageRuntime()).build();
    static final AttributeDefinition EXPIRY_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"expiry-address", (ModelType)ModelType.STRING).setAllowNull(true)).setStorageRuntime()).build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{QUEUE_ADDRESS, EXPIRY_ADDRESS, DEAD_LETTER_ADDRESS, CommonAttributes.PAUSED, CommonAttributes.TEMPORARY};
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.SCHEDULED_COUNT, CommonAttributes.CONSUMER_COUNT};
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private static AttributeDefinition[] getDeploymentAttributes() {
        return new AttributeDefinition[]{((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder(CommonAttributes.DESTINATION_ENTRIES).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.SELECTOR).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.DURABLE).setStorageRuntime()).build()};
    }

    public static JMSQueueDefinition newDeployedJMSQueueDefinition() {
        return new JMSQueueDefinition(true, true, null, null);
    }

    public JMSQueueDefinition(boolean registerRuntimeOnly) {
        this(registerRuntimeOnly, false, (OperationStepHandler)JMSQueueAdd.INSTANCE, (OperationStepHandler)JMSQueueRemove.INSTANCE);
    }

    private JMSQueueDefinition(boolean registerRuntimeOnly, boolean deployed, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("jms-queue"), addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("messaging", "jms-queue");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        AttributeDefinition[] attributes;
        super.registerAttributes(registry);
        for (AttributeDefinition attr : attributes = this.deployed ? JMSQueueDefinition.getDeploymentAttributes() : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSQueueConfigurationRuntimeHandler.INSTANCE);
                continue;
            }
            if (attr == CommonAttributes.DESTINATION_ENTRIES) {
                registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)JMSQueueConfigurationWriteHandler.INSTANCE);
                continue;
            }
            registry.registerReadOnlyAttribute(attr, null);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSQueueReadAttributeHandler.INSTANCE);
            }
            for (AttributeDefinition metric : METRICS) {
                registry.registerMetric(metric, (OperationStepHandler)JMSQueueReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            JMSQueueControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
            if (!this.deployed) {
                JMSQueueUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
            }
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

