/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSTopicRemove
extends AbstractRemoveStepHandler {
    public static final JMSTopicRemove INSTANCE = new JMSTopicRemove(JMSTopicAdd.INSTANCE);
    private final JMSTopicAdd addOperation;

    private JMSTopicRemove(JMSTopicAdd addOperation) {
        this.addOperation = addOperation;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String[] jndiBindings;
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        JMSServerControl control = (JMSServerControl)JMSServerControl.class.cast(hqServer.getManagementService().getResource("jms.server"));
        if (control != null) {
            try {
                control.destroyTopic(name, true);
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        context.removeService(JMSServices.getJmsTopicBaseServiceName(hqServiceName).append(new String[]{name}));
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        for (String jndiBinding : jndiBindings = JMSServices.getJndiBindings(entries)) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiBinding);
            ServiceName binderServiceName = bindInfo.getBinderServiceName();
            context.removeService(binderServiceName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.addOperation.performRuntime(context, operation, model, new ServiceVerificationHandler(), new ArrayList());
    }
}

