/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.claims;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.logging.LogUtils;

public class Claim
implements Serializable {
    private static final long serialVersionUID = 5730726672368086795L;
    private static final Logger LOG = LogUtils.getL7dLogger(Claim.class);
    private URI claimType;
    private boolean optional;
    private List<Object> values = new ArrayList<Object>(1);

    public URI getClaimType() {
        return this.claimType;
    }

    public void setClaimType(URI claimType) {
        this.claimType = claimType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setValues(List<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void addValue(Object s) {
        this.values.add(s);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void serialize(XMLStreamWriter writer, String prefix, String namespace) throws XMLStreamException {
        String localname = "ClaimType";
        if (!this.values.isEmpty()) {
            localname = "ClaimValue";
        }
        writer.writeStartElement(prefix, localname, namespace);
        writer.writeAttribute(null, "Uri", this.claimType.toString());
        if (this.optional) {
            writer.writeAttribute(null, "Optional", "true");
        }
        if (!this.values.isEmpty()) {
            for (Object value : this.values) {
                if (value instanceof String) {
                    writer.writeStartElement(prefix, "Value", namespace);
                    writer.writeCharacters((String)value);
                    writer.writeEndElement();
                    continue;
                }
                LOG.warning("Only a ClaimValue String can be serialized");
            }
        }
        writer.writeEndElement();
    }
}

