/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.error.SimpleErrorPageHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class Server
implements Service<Server> {
    private final String defaultHost;
    private final String name;
    private final NameVirtualHostHandler virtualHostHandler = new NameVirtualHostHandler();
    private final InjectedValue<ServletContainerService> servletContainer = new InjectedValue();
    private final InjectedValue<UndertowService> undertowService = new InjectedValue();
    private volatile HttpHandler root;
    private final List<ListenerService<?>> listeners = new LinkedList();
    private final Set<Host> hosts = new CopyOnWriteArraySet<Host>();
    private final HashMap<Integer, Integer> securePortMappings = new HashMap();

    protected Server(String name, String defaultHost) {
        this.name = name;
        this.defaultHost = defaultHost;
    }

    public void start(StartContext startContext) throws StartException {
        this.root = this.virtualHostHandler;
        this.root = new SimpleErrorPageHandler(this.root);
        this.root = new CanonicalPathHandler(this.root);
        UndertowLogger.ROOT_LOGGER.startedServer(this.name);
        ((UndertowService)this.undertowService.getValue()).registerServer(this);
    }

    protected void registerListener(ListenerService<?> listener) {
        this.listeners.add(listener);
        if (!listener.isSecure()) {
            SocketBinding binding = (SocketBinding)listener.getBinding().getValue();
            SocketBinding redirectBinding = (SocketBinding)listener.getRedirectSocket().getValue();
            this.securePortMappings.put(binding.getAbsolutePort(), redirectBinding.getAbsolutePort());
        }
    }

    protected void unregisterListener(ListenerService<?> listener) {
        this.listeners.remove(listener);
        if (!listener.isSecure()) {
            SocketBinding binding = (SocketBinding)listener.getBinding().getValue();
            this.securePortMappings.remove(binding.getAbsolutePort());
        }
    }

    protected void registerHost(Host host) {
        this.hosts.add(host);
        for (String hostName : host.getAllAliases()) {
            this.virtualHostHandler.addHost(hostName, host.getRootHandler());
        }
        if (host.getName().equals(this.getDefaultHost())) {
            this.virtualHostHandler.setDefaultHandler(host.getRootHandler());
        }
    }

    protected void unregisterHost(Host host) {
        for (String hostName : host.getAllAliases()) {
            this.virtualHostHandler.removeHost(hostName);
            this.hosts.remove(host);
        }
        if (host.getName().equals(this.getDefaultHost())) {
            this.virtualHostHandler.setDefaultHandler((HttpHandler)ResponseCodeHandler.HANDLE_404);
        }
    }

    public int lookupSecurePort(int unsecurePort) {
        return this.securePortMappings.get(unsecurePort);
    }

    public void stop(StopContext stopContext) {
        ((UndertowService)this.undertowService.getValue()).unregisterServer(this);
    }

    public Server getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    Injector<ServletContainerService> getServletContainerInjector() {
        return this.servletContainer;
    }

    public ServletContainerService getServletContainer() {
        return (ServletContainerService)this.servletContainer.getValue();
    }

    protected HttpHandler getRoot() {
        return this.root;
    }

    Injector<UndertowService> getUndertowServiceInjector() {
        return this.undertowService;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public Set<Host> getHosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public List<ListenerService<?>> getListeners() {
        return this.listeners;
    }
}

