/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.SessionManager;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.extension.undertow.deployment.ImmediateSessionManagerFactory;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilder;
import org.wildfly.extension.undertow.session.DistributableSessionManagerFactoryBuilderValue;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;
import org.wildfly.extension.undertow.session.SimpleDistributableSessionManagerConfiguration;

public class SharedSessionManagerDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SharedSessionManagerConfig sharedConfig = (SharedSessionManagerConfig)deploymentUnit.getAttachment(UndertowAttachments.SHARED_SESSION_MANAGER_CONFIG);
        if (sharedConfig == null) {
            return;
        }
        ServiceTarget target = phaseContext.getServiceTarget();
        ServiceName deploymentServiceName = deploymentUnit.getServiceName();
        ServiceName serviceName = deploymentServiceName.append(SharedSessionManagerConfig.SHARED_SESSION_MANAGER_SERVICE_NAME);
        DistributableSessionManagerFactoryBuilder builder = new DistributableSessionManagerFactoryBuilderValue().getValue();
        if (builder != null) {
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            builder.build(target, serviceName, new SimpleDistributableSessionManagerConfiguration(sharedConfig, deploymentUnit.getName(), module)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            InMemorySessionManager manager = new InMemorySessionManager(deploymentUnit.getName(), sharedConfig.getMaxActiveSessions());
            if (sharedConfig.getSessionConfig() != null && sharedConfig.getSessionConfig().getSessionTimeoutSet()) {
                manager.setDefaultSessionTimeout(sharedConfig.getSessionConfig().getSessionTimeout());
            }
            ImmediateSessionManagerFactory factory = new ImmediateSessionManagerFactory((SessionManager)manager);
            target.addService(serviceName, (Service)new ValueService((Value)new ImmediateValue((Object)factory))).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

