/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl.remote;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.BusinessActivityManagerFactory;
import com.arjuna.mw.wst11.UserBusinessActivityFactory;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.BAParticipantManager;
import java.util.HashMap;
import java.util.UUID;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.TransactionCompensatedException;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.impl.BAControler;
import org.jboss.narayana.compensations.impl.CompensationManagerImpl;
import org.jboss.narayana.compensations.impl.CompensationManagerState;
import org.jboss.narayana.compensations.impl.ParticipantManager;
import org.jboss.narayana.compensations.impl.remote.RemoteParticipant;
import org.jboss.narayana.compensations.impl.remote.RemoteParticipantManager;
import org.jboss.narayana.txframework.impl.TXDataMapImpl;

public class RemoteBAControler
implements BAControler {
    @Override
    public void beginBusinessActivity() throws WrongStateException, SystemException {
        UserBusinessActivityFactory.userBusinessActivity().begin();
        CompensationManagerImpl.resume(new CompensationManagerState());
        TXDataMapImpl.resume(new HashMap());
    }

    @Override
    public void closeBusinessActivity() throws WrongStateException, UnknownTransactionException, TransactionRolledBackException, SystemException {
        UserBusinessActivityFactory.userBusinessActivity().close();
        CompensationManagerImpl.suspend();
        TXDataMapImpl.suspend();
    }

    @Override
    public void cancelBusinessActivity() throws WrongStateException, UnknownTransactionException, SystemException {
        UserBusinessActivityFactory.userBusinessActivity().cancel();
        CompensationManagerImpl.suspend();
        TXDataMapImpl.suspend();
    }

    @Override
    public void completeBusinessActivity(boolean isException) throws WrongStateException, UnknownTransactionException, SystemException {
        if (CompensationManagerImpl.isCompensateOnly() && !isException) {
            this.cancelBusinessActivity();
            throw new TransactionCompensatedException("Transaction was marked as 'compensate only'");
        }
        if (CompensationManagerImpl.isCompensateOnly()) {
            this.cancelBusinessActivity();
        } else {
            try {
                this.closeBusinessActivity();
            }
            catch (TransactionRolledBackException e) {
                throw new TransactionCompensatedException("Failed to close transaction", e);
            }
        }
    }

    @Override
    public boolean isBARunning() {
        try {
            BusinessActivityManager businessActivityManager = BusinessActivityManagerFactory.businessActivityManager();
            if (businessActivityManager == null) {
                return false;
            }
            return BusinessActivityManagerFactory.businessActivityManager().currentTransaction() != null;
        }
        catch (SystemException e) {
            return false;
        }
    }

    @Override
    public Object suspend() throws Exception {
        return BusinessActivityManagerFactory.businessActivityManager().suspend();
    }

    @Override
    public void resume(Object context) throws Exception {
        BusinessActivityManagerFactory.businessActivityManager().resume((TxContext)context);
    }

    @Override
    public Object getCurrentTransaction() throws Exception {
        return BusinessActivityManagerFactory.businessActivityManager().currentTransaction();
    }

    @Override
    public ParticipantManager enlist(Class<? extends CompensationHandler> compensationHandlerClass, Class<? extends ConfirmationHandler> confirmationHandlerClass, Class<? extends TransactionLoggedHandler> transactionLoggedHandlerClass) throws Exception {
        RemoteParticipant p = new RemoteParticipant(compensationHandlerClass, confirmationHandlerClass, transactionLoggedHandlerClass, this.getCurrentTransaction());
        BAParticipantManager pm = BusinessActivityManagerFactory.businessActivityManager().enlistForBusinessAgreementWithParticipantCompletion((BusinessAgreementWithParticipantCompletionParticipant)p, String.valueOf(UUID.randomUUID()));
        return new RemoteParticipantManager(pm);
    }
}

