/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ejb.EJB;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.bootstrap.AbstractResourceInjectionServices;
import org.jboss.as.weld.services.bootstrap.ComponentViewToResourceReferenceFactoryAdapter;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.reflection.Reflections;

public class WeldEjbInjectionServices
extends AbstractResourceInjectionServices
implements EjbInjectionServices {
    private final EEApplicationDescription applicationDescription;
    private final VirtualFile deploymentRoot;

    public WeldEjbInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription, EEApplicationDescription applicationDescription, VirtualFile deploymentRoot) {
        super(serviceRegistry, moduleDescription);
        if (serviceRegistry == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("serviceRegistry");
        }
        if (moduleDescription == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("moduleDescription");
        }
        if (applicationDescription == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("applicationDescription");
        }
        if (deploymentRoot == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("deploymentRoot");
        }
        this.applicationDescription = applicationDescription;
        this.deploymentRoot = deploymentRoot;
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public ResourceReferenceFactory<Object> registerEjbInjectionPoint(InjectionPoint injectionPoint) {
        EJB ejb = (EJB)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(EJB.class);
        if (ejb == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(EJB.class, injectionPoint.getMember());
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw WeldLogger.ROOT_LOGGER.injectionPointNotAJavabean((Method)injectionPoint.getMember());
        }
        if (!ejb.lookup().equals("")) {
            return this.handleServiceLookup(ejb.lookup(), injectionPoint);
        }
        ViewDescription viewDescription = this.getViewDescription(ejb, injectionPoint);
        if (viewDescription != null) {
            return this.handleServiceLookup(viewDescription, injectionPoint);
        }
        final String proposedName = ResourceInjectionUtilities.getEjbBindLocation(injectionPoint);
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(WeldEjbInjectionServices.this.doLookup(proposedName, null));
            }
        };
    }

    private ResourceReferenceFactory<Object> handleServiceLookup(ViewDescription viewDescription, InjectionPoint injectionPoint) {
        ComponentView view = this.getComponentView(viewDescription);
        if (view != null && injectionPoint.getAnnotated().isAnnotationPresent(Produces.class)) {
            Class clazz = view.getViewClass();
            Class injectionPointRawType = Reflections.getRawType((Type)injectionPoint.getType());
            boolean found = false;
            for (Class c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
                if (!injectionPointRawType.getName().equals(c.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw BeanLogger.LOG.invalidResourceProducerType((Object)injectionPoint.getAnnotated(), (Object)clazz.getName());
            }
            return new ComponentViewToResourceReferenceFactoryAdapter<Object>(view);
        }
        return this.createLazyResourceReferenceFactory(viewDescription);
    }

    private ComponentView getComponentView(ViewDescription viewDescription) {
        ServiceController controller = this.serviceRegistry.getRequiredService(viewDescription.getServiceName());
        return (ComponentView)controller.getValue();
    }

    private ViewDescription getViewDescription(EJB ejb, InjectionPoint injectionPoint) {
        Set viewService = ejb.beanName().isEmpty() ? (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponentsForViewName(ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponentsForViewName(WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot)) : (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponents(ejb.beanName(), ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponents(ejb.beanName(), WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot));
        if (injectionPoint.getAnnotated().isAnnotationPresent(Produces.class)) {
            if (viewService.isEmpty()) {
                throw WeldLogger.ROOT_LOGGER.ejbNotResolved(ejb, injectionPoint.getMember());
            }
            if (viewService.size() > 1) {
                throw WeldLogger.ROOT_LOGGER.moreThanOneEjbResolved(ejb, injectionPoint.getMember(), viewService);
            }
        } else {
            if (viewService.isEmpty()) {
                return null;
            }
            if (viewService.size() > 1) {
                return null;
            }
        }
        return (ViewDescription)viewService.iterator().next();
    }

    @Override
    protected ContextNames.BindInfo getBindInfo(String result) {
        return ContextNames.bindInfoFor((String)this.moduleDescription.getApplicationName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (String)result);
    }

    public void cleanup() {
    }

    private static Class<?> getType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return WeldEjbInjectionServices.getType(((ParameterizedType)type).getRawType());
        }
        throw WeldLogger.ROOT_LOGGER.couldNotDetermineUnderlyingType(type);
    }

    protected ResourceReferenceFactory<Object> createLazyResourceReferenceFactory(final ViewDescription viewDescription) {
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                try {
                    ServiceController controller = WeldEjbInjectionServices.this.serviceRegistry.getRequiredService(viewDescription.getServiceName());
                    ComponentView view = (ComponentView)controller.getValue();
                    final ManagedReference instance = view.createInstance();
                    return new ResourceReference<Object>(){

                        public Object getInstance() {
                            return instance.getInstance();
                        }

                        public void release() {
                            instance.release();
                        }
                    };
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Object doLookup(String jndiName, String mappedName) {
        String name = ResourceInjectionUtilities.getResourceName(jndiName, mappedName);
        try {
            return new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw WeldLogger.ROOT_LOGGER.couldNotFindResource(name, e);
        }
    }
}

