/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.CompilationResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

class CompilationMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final CompilationMXBeanAttributeHandler INSTANCE = new CompilationMXBeanAttributeHandler();

    private CompilationMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || CompilationResourceDefinition.COMPILATION_READ_ATTRIBUTES.contains(name) || CompilationResourceDefinition.COMPILATION_METRICS.contains(name))) {
                throw CompilationMXBeanAttributeHandler.unknownAttribute(operation);
            }
            CompilationMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    static void storeResult(String attributeName, ModelNode store) throws OperationFailedException {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(attributeName)) {
            store.set("java.lang:type=Compilation");
        } else if ("name".equals(attributeName)) {
            store.set(ManagementFactory.getCompilationMXBean().getName());
        } else if ("compilation-time-monitoring-supported".equals(attributeName)) {
            store.set(ManagementFactory.getCompilationMXBean().isCompilationTimeMonitoringSupported());
        } else if ("total-compilation-time".equals(attributeName)) {
            store.set(ManagementFactory.getCompilationMXBean().getTotalCompilationTime());
        } else if (CompilationResourceDefinition.COMPILATION_READ_ATTRIBUTES.contains(attributeName) || CompilationResourceDefinition.COMPILATION_METRICS.contains(attributeName)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(attributeName);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw CompilationMXBeanAttributeHandler.unknownAttribute(operation);
    }
}

