/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.ThreadResourceDefinition;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ThreadMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final ThreadMXBeanAttributeHandler INSTANCE = new ThreadMXBeanAttributeHandler();
    private final ParametersValidator enabledValidator = new ParametersValidator();

    private ThreadMXBeanAttributeHandler() {
        this.enabledValidator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || ThreadResourceDefinition.THREADING_READ_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_READ_WRITE_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_METRICS.contains(name))) {
                throw ThreadMXBeanAttributeHandler.unknownAttribute(operation);
            }
            ThreadMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException | UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block6: {
            String name = operation.require("name").asString();
            try {
                if ("thread-contention-monitoring-enabled".equals(name)) {
                    this.enabledValidator.validate(operation);
                    context.getServiceRegistry(true);
                    ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(operation.require("value").asBoolean());
                    break block6;
                }
                if ("thread-cpu-time-enabled".equals(name)) {
                    this.enabledValidator.validate(operation);
                    context.getServiceRegistry(true);
                    ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(operation.require("value").asBoolean());
                    break block6;
                }
                if (ThreadResourceDefinition.THREADING_READ_WRITE_ATTRIBUTES.contains(name)) {
                    throw PlatformMBeanLogger.ROOT_LOGGER.badWriteAttributeImpl(name);
                }
                throw ThreadMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            store.set("java.lang:type=Threading");
        } else if ("thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getThreadCount());
        } else if ("peak-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getPeakThreadCount());
        } else if ("total-started-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getTotalStartedThreadCount());
        } else if ("daemon-thread-count".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getDaemonThreadCount());
        } else if ("all-thread-ids".equals(name)) {
            store.setEmptyList();
            long[] arr$ = ManagementFactory.getThreadMXBean().getAllThreadIds();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Long id = arr$[i$];
                store.add(id.longValue());
            }
        } else if ("thread-contention-monitoring-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadContentionMonitoringSupported());
        } else if ("thread-contention-monitoring-enabled".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadContentionMonitoringEnabled());
        } else if ("current-thread-cpu-time".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
        } else if ("current-thread-user-time".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().getCurrentThreadUserTime());
        } else if ("thread-cpu-time-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadCpuTimeSupported());
        } else if ("current-thread-cpu-time-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported());
        } else if ("thread-cpu-time-enabled".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled());
        } else if ("object-monitor-usage-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isObjectMonitorUsageSupported());
        } else if ("synchronizer-usage-supported".equals(name)) {
            store.set(ManagementFactory.getThreadMXBean().isSynchronizerUsageSupported());
        } else if (ThreadResourceDefinition.THREADING_READ_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_READ_WRITE_ATTRIBUTES.contains(name) || ThreadResourceDefinition.THREADING_METRICS.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }
}

