/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.CommonAttributes;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanThreadInfoHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-thread-info", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setParameters(new AttributeDefinition[]{CommonAttributes.ID, CommonAttributes.MAX_DEPTH}).setReplyType(ModelType.OBJECT).setReplyParameters(CommonAttributes.THREAD_INFO_ATTRIBUTES).setReadOnly().setRuntimeOnly().allowReturnNull().build();
    public static final ThreadMXBeanThreadInfoHandler INSTANCE = new ThreadMXBeanThreadInfoHandler();
    private final ParametersValidator validator = new ParametersValidator();

    private ThreadMXBeanThreadInfoHandler() {
        this.validator.registerValidator("id", (ParameterValidator)new LongRangeValidator(1L));
        this.validator.registerValidator("max-depth", (ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, false));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        try {
            long id = operation.require("id").asLong();
            ThreadInfo info = operation.hasDefined("max-depth") ? mbean.getThreadInfo(id, operation.require("max-depth").asInt()) : mbean.getThreadInfo(id);
            ModelNode result = context.getResult();
            if (info != null) {
                result.set(PlatformMBeanUtil.getDetypedThreadInfo(info, mbean.isThreadCpuTimeSupported()));
            }
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        context.stepCompleted();
    }
}

