/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import org.jboss.as.controller.Extension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResource;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExtensionAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ExtensionRegistry extensionRegistry;
    private final boolean parallelBoot;
    private final boolean isMasterDomainController;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ExtensionAddHandler(ExtensionRegistry extensionRegistry, boolean parallelBoot, boolean isMasterDomainController, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        assert (extensionRegistry != null) : "extensionRegistry is null";
        this.extensionRegistry = extensionRegistry;
        this.parallelBoot = parallelBoot;
        this.isMasterDomainController = isMasterDomainController;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ManagementResourceRegistration rootRegistration;
        boolean install;
        final String moduleName = PathAddress.pathAddress(operation.require("address")).getLastElement().getValue();
        final ExtensionResource resource = new ExtensionResource(moduleName, this.extensionRegistry);
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        boolean bl = install = !this.parallelBoot || !context.isBooting();
        if (install) {
            rootRegistration = this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
            ExtensionAddHandler.initializeExtension(this.extensionRegistry, moduleName, rootRegistration, this.isMasterDomainController);
            if (this.isMasterDomainController && !context.isBooting()) {
                ModelNode subsystems = new ModelNode();
                this.extensionRegistry.recordSubsystemVersions(moduleName, subsystems);
                context.getResult().set(subsystems);
            }
        } else {
            rootRegistration = null;
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (install) {
                    ExtensionAddHandler.this.extensionRegistry.removeExtension(resource, moduleName, rootRegistration);
                }
            }
        });
    }

    void initializeExtension(String module, ManagementResourceRegistration rootRegistration) {
        ExtensionAddHandler.initializeExtension(this.extensionRegistry, module, rootRegistration, this.isMasterDomainController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeExtension(ExtensionRegistry extensionRegistry, String module, ManagementResourceRegistration rootRegistration, boolean isMasterDomainController) {
        try {
            boolean unknownModule = false;
            for (Extension extension : Module.loadServiceFromCallerModuleLoader((ModuleIdentifier)ModuleIdentifier.fromString((String)module), Extension.class)) {
                ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(extension.getClass());
                try {
                    if (unknownModule || !extensionRegistry.getExtensionModuleNames().contains(module)) {
                        extension.initializeParsers(extensionRegistry.getExtensionParsingContext(module, null));
                        unknownModule = true;
                    }
                    extension.initialize(extensionRegistry.getExtensionContext(module, rootRegistration, isMasterDomainController));
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                }
            }
        }
        catch (ModuleNotFoundException e) {
            throw ControllerLogger.ROOT_LOGGER.extensionModuleNotFound(e, module);
        }
        catch (ModuleLoadException e) {
            throw ControllerLogger.ROOT_LOGGER.extensionModuleLoadingFailure(e, module);
        }
    }
}

