/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.context.cache.RequestScopedCache;

public class CachedBeanInstance
implements BeanInstance,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<Class<? extends Annotation>> CACHEABLE_SCOPES = ImmutableSet.of(RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class);
    private final BeanInstance delegate;
    private final transient ThreadLocal<Object> instanceCache;

    public static BeanInstance wrapIfCacheable(Bean<?> bean, BeanInstance beanInstance) {
        if (!CACHEABLE_SCOPES.contains(bean.getScope())) {
            return beanInstance;
        }
        return new CachedBeanInstance(beanInstance);
    }

    private CachedBeanInstance(BeanInstance delegate) {
        this.delegate = delegate;
        this.instanceCache = new ThreadLocal();
    }

    @Override
    public Object getInstance() {
        Object instance = this.instanceCache.get();
        if (instance == null) {
            instance = this.delegate.getInstance();
            if (RequestScopedCache.addItemIfActive(this.instanceCache)) {
                this.instanceCache.set(instance);
            }
        }
        return instance;
    }

    @Override
    public Class<?> getInstanceType() {
        return this.delegate.getInstanceType();
    }

    @Override
    public Object invoke(Object instance, Method method, Object ... arguments) throws Throwable {
        return this.delegate.invoke(instance, method, arguments);
    }

    private Object readResolve() throws ObjectStreamException {
        return new CachedBeanInstance(this.delegate);
    }
}

