/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.bean.proxy.InterceptionDecorationContext;
import org.jboss.weld.bean.proxy.StackAwareMethodHandler;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.SecurityActions;
import org.jboss.weld.interceptor.proxy.WeldInvocationContext;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptorMethodHandler
implements StackAwareMethodHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InterceptionContext ctx;
    private final transient ConcurrentMap<Method, List<InterceptorMethodInvocation>> cachedChains;

    public InterceptorMethodHandler(InterceptionContext ctx) {
        this.ctx = ctx;
        this.cachedChains = new ConcurrentHashMap<Method, List<InterceptorMethodInvocation>>();
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        return this.invoke(InterceptionDecorationContext.getStack(), self, thisMethod, proceed, args);
    }

    @Override
    public Object invoke(InterceptionDecorationContext.Stack stack, Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        SecurityActions.ensureAccessible(proceed);
        if (proceed == null) {
            if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
                return this.executeInterception(self, null, null, null, InterceptionType.POST_CONSTRUCT, stack);
            }
            if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
                return this.executeInterception(self, null, null, null, InterceptionType.PRE_DESTROY, stack);
            }
        } else {
            if (this.isInterceptorMethod(thisMethod)) {
                return Reflections.invokeAndUnwrap(self, proceed, args);
            }
            return this.executeInterception(self, thisMethod, proceed, args, InterceptionType.AROUND_INVOKE, stack);
        }
        return null;
    }

    protected Object executeInterception(Object instance, Method method, Method proceed, Object[] args, InterceptionType interceptionType, InterceptionDecorationContext.Stack stack) throws Throwable {
        List<InterceptorMethodInvocation> chain = this.getInterceptionChain(instance, method, interceptionType);
        if (chain.isEmpty()) {
            if (proceed == null) {
                return null;
            }
            return Reflections.invokeAndUnwrap(instance, proceed, args);
        }
        return new WeldInvocationContext(instance, method, proceed, args, chain, stack).proceed();
    }

    private List<InterceptorMethodInvocation> getInterceptionChain(Object instance, Method method, InterceptionType interceptionType) {
        if (method != null) {
            List<InterceptorMethodInvocation> old;
            List<InterceptorMethodInvocation> chain = (List<InterceptorMethodInvocation>)this.cachedChains.get(method);
            if (chain == null && (old = this.cachedChains.putIfAbsent(method, chain = this.ctx.buildInterceptorMethodInvocations(instance, method, interceptionType))) != null) {
                chain = old;
            }
            return chain;
        }
        return this.ctx.buildInterceptorMethodInvocations(instance, null, interceptionType);
    }

    private boolean isInterceptorMethod(Method method) {
        return this.ctx.getInterceptionModel().getTargetClassInterceptorMetadata().isInterceptorMethod(method);
    }

    private Object readResolve() throws ObjectStreamException {
        return new InterceptorMethodHandler(this.ctx);
    }
}

