/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection.instantiation;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.jboss.weld.logging.ReflectionLogger;
import org.jboss.weld.security.GetDeclaredFieldAction;
import org.jboss.weld.security.GetDeclaredMethodAction;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.reflection.instantiation.Instantiator;

public class UnsafeInstantiator
implements Instantiator {
    private static final String REFLECTION_CLASS_NAME = "sun.misc.Unsafe";
    private Method allocateInstanceMethod = null;
    private Object unsafeInstance = null;

    @SuppressWarnings(value={"DE_MIGHT_IGNORE", "REC_CATCH_EXCEPTION"}, justification="The exception is expected to be ignored.")
    private void init() {
        try {
            Class<?> unsafe = Class.forName(REFLECTION_CLASS_NAME);
            Field accessor = AccessController.doPrivileged(new GetDeclaredFieldAction(unsafe, "theUnsafe"));
            AccessController.doPrivileged(SetAccessibleAction.of(accessor));
            this.unsafeInstance = accessor.get(null);
            this.allocateInstanceMethod = AccessController.doPrivileged(GetDeclaredMethodAction.of(unsafe, "allocateInstance", Class.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isAvailable() {
        this.init();
        return this.allocateInstanceMethod != null && this.unsafeInstance != null;
    }

    @Override
    @SuppressWarnings(value={"unchecked"})
    public <T> T instantiate(Class<T> clazz) {
        try {
            return (T)this.allocateInstanceMethod.invoke(this.unsafeInstance, clazz);
        }
        catch (Exception e) {
            throw ReflectionLogger.LOG.unsafeInstantiationFailed(clazz, e);
        }
    }
}

