/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.io.IOException;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;

public class ProtobufMatcherEvalContext
extends MatcherEvalContext<Descriptor, FieldDescriptor, Integer>
implements TagHandler {
    private static final Object DUMMY_VALUE = new Object();
    private boolean payloadStarted = false;
    private int skipping = 0;
    private byte[] payload;
    private String entityTypeName;
    private Descriptor payloadMessageDescriptor;
    private MessageContext messageContext;
    private final SerializationContext serializationContext;
    private final Descriptor wrappedMessageDescriptor;

    public ProtobufMatcherEvalContext(Object instance, Descriptor wrappedMessageDescriptor, SerializationContext serializationContext) {
        super(instance);
        this.wrappedMessageDescriptor = wrappedMessageDescriptor;
        this.serializationContext = serializationContext;
    }

    @Override
    public Descriptor getEntityType() {
        return this.payloadMessageDescriptor;
    }

    public void unwrapPayload() {
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)this, this.wrappedMessageDescriptor, (byte[])this.getInstance());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onStart() {
    }

    public void onTag(int fieldNumber, String fieldName, Type type, JavaType javaType, Object tagValue) {
        if (this.payloadStarted) {
            AttributeNode<FieldDescriptor, Integer> attrNode;
            if (this.skipping == 0 && (attrNode = this.currentNode.getChild(fieldNumber)) != null) {
                this.messageContext.markField(fieldNumber);
                attrNode.processValue(tagValue, this);
            }
        } else {
            switch (fieldNumber) {
                case 16: {
                    this.entityTypeName = (String)tagValue;
                    break;
                }
                case 19: {
                    this.entityTypeName = this.serializationContext.getTypeNameById((Integer)tagValue);
                    break;
                }
                case 17: {
                    this.payload = (byte[])tagValue;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected field : " + fieldNumber);
                }
            }
        }
    }

    public void onStartNested(int fieldNumber, String fieldName, Descriptor messageDescriptor) {
        if (this.payloadStarted) {
            AttributeNode attrNode;
            if (this.skipping == 0 && (attrNode = this.currentNode.getChild(fieldNumber)) != null) {
                this.messageContext.markField(fieldNumber);
                this.pushContext(fieldName, messageDescriptor);
                this.currentNode = attrNode;
                return;
            }
            ++this.skipping;
        } else {
            throw new IllegalStateException("No nested message is expected");
        }
    }

    public void onEndNested(int fieldNumber, String fieldName, Descriptor messageDescriptor) {
        if (this.payloadStarted) {
            if (this.skipping == 0) {
                this.popContext();
                this.currentNode = this.currentNode.getParent();
            } else {
                --this.skipping;
            }
        } else {
            throw new IllegalStateException("No nested message is expected");
        }
    }

    public void onEnd() {
        if (this.payloadStarted) {
            this.processMissingFields();
        } else {
            this.payloadStarted = true;
            if (this.payload != null) {
                if (this.entityTypeName == null) {
                    throw new IllegalStateException("Descriptor name is missing");
                }
                this.payloadMessageDescriptor = this.serializationContext.getMessageDescriptor(this.entityTypeName);
                this.messageContext = new MessageContext(null, null, this.payloadMessageDescriptor);
            }
        }
    }

    @Override
    protected void processAttributes(AttributeNode<FieldDescriptor, Integer> node, Object instance) {
        try {
            ProtobufParser.INSTANCE.parse((TagHandler)this, this.payloadMessageDescriptor, this.payload);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void pushContext(String fieldName, Descriptor messageDescriptor) {
        this.messageContext = new MessageContext(this.messageContext, fieldName, messageDescriptor);
    }

    private void popContext() {
        this.processMissingFields();
        this.messageContext = this.messageContext.getParentContext();
    }

    private void processMissingFields() {
        for (FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            AttributeNode<FieldDescriptor, Integer> attributeNode = this.currentNode.getChild(fd.getNumber());
            boolean fieldSeen = this.messageContext.isFieldMarked(fd.getNumber());
            if (attributeNode == null || !fd.isRepeated() && fieldSeen) continue;
            if (fd.isRepeated()) {
                if (fieldSeen) {
                    attributeNode.processValue(DUMMY_VALUE, this);
                    continue;
                }
                this.processNullAttribute(attributeNode);
                continue;
            }
            if (fd.getJavaType() == JavaType.MESSAGE) {
                this.processNullAttribute(attributeNode);
                continue;
            }
            Object defaultValue = fd.hasDefaultValue() ? fd.getDefaultValue() : null;
            attributeNode.processValue(defaultValue, this);
        }
    }

    private void processNullAttribute(AttributeNode<FieldDescriptor, Integer> attributeNode) {
        attributeNode.processValue(null, this);
        for (AttributeNode<FieldDescriptor, Integer> childAttribute : attributeNode.getChildren()) {
            this.processNullAttribute(childAttribute);
        }
    }
}

