/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.jboss.wsf.stack.cxf.client.ClientBusSelector;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;

public class JBossWSBusFactory
extends BusFactory {
    private static final Map<ClassLoader, Bus> classLoaderBusses = new WeakHashMap<ClassLoader, Bus>();
    private JBossWSSpringBusFactory springBusFactory;
    private JBossWSNonSpringBusFactory nonSpringBusFactory;

    public Bus createBus() {
        if (this.isSpringAvailable()) {
            return this.getSpringBusFactory().createBus();
        }
        return this.getNonSpringBusFactory().createBus();
    }

    private boolean isSpringAvailable() {
        return SpringUtils.isSpringAvailable(new ClassLoader[0]) && (this.springBusFactory != null || SpringUtils.isSpringAvailable(((Object)((Object)this)).getClass().getClassLoader()));
    }

    public Bus createBus(String cfgFile) {
        return this.getSpringBusFactory().createBus(cfgFile, true);
    }

    public Bus createBus(String[] cfgFiles) {
        return this.getSpringBusFactory().createBus(cfgFiles, true);
    }

    public Bus createBus(String cfgFile, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(cfgFile, includeDefaults);
    }

    public Bus createBus(String[] cfgFiles, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(cfgFiles, includeDefaults);
    }

    public Bus createBus(URL url) {
        return this.getSpringBusFactory().createBus(url);
    }

    public Bus createBus(URL[] urls) {
        return this.getSpringBusFactory().createBus(urls);
    }

    public Bus createBus(URL url, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(url, includeDefaults);
    }

    public Bus createBus(URL[] urls, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(urls, includeDefaults);
    }

    public Bus createBus(Map<Class<?>, Object> extensions) {
        return this.getNonSpringBusFactory().createBus(extensions);
    }

    public Bus createBus(Map<Class<?>, Object> extensions, Map<String, Object> properties) {
        return this.getNonSpringBusFactory().createBus(extensions, properties);
    }

    public synchronized JBossWSSpringBusFactory getSpringBusFactory() {
        if (this.springBusFactory == null) {
            this.springBusFactory = new JBossWSSpringBusFactory();
        }
        return this.springBusFactory;
    }

    public synchronized JBossWSNonSpringBusFactory getNonSpringBusFactory() {
        if (this.nonSpringBusFactory == null) {
            this.nonSpringBusFactory = new JBossWSNonSpringBusFactory();
        }
        return this.nonSpringBusFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getDefaultBus(ClassLoader contextClassLoader) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(contextClassLoader);
            Bus bus = BusFactory.getDefaultBus();
            return bus;
        }
        finally {
            SecurityActions.setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getClassLoaderDefaultBus(ClassLoader classloader, ClientBusSelector clientBusSelector) {
        Bus classLoaderBus;
        Map<ClassLoader, Bus> map = classLoaderBusses;
        synchronized (map) {
            classLoaderBus = classLoaderBusses.get(classloader);
            if (classLoaderBus == null) {
                classLoaderBus = clientBusSelector.createNewBus();
                ClassLoaderDefaultBusLifeCycleListener listener = new ClassLoaderDefaultBusLifeCycleListener(classLoaderBus);
                ((BusLifeCycleManager)classLoaderBus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)listener);
                classLoaderBusses.put(classloader, classLoaderBus);
            }
        }
        return classLoaderBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getClassLoaderDefaultBus(ClassLoader classloader) {
        Bus classLoaderBus;
        Map<ClassLoader, Bus> map = classLoaderBusses;
        synchronized (map) {
            classLoaderBus = classLoaderBusses.get(classloader);
            if (classLoaderBus == null) {
                classLoaderBus = new JBossWSBusFactory().createBus();
                ClassLoaderDefaultBusLifeCycleListener listener = new ClassLoaderDefaultBusLifeCycleListener(classLoaderBus);
                ((BusLifeCycleManager)classLoaderBus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)listener);
                classLoaderBusses.put(classloader, classLoaderBus);
            }
        }
        return classLoaderBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDefaultBusForAnyClassLoader(Bus bus) {
        Map<ClassLoader, Bus> map = classLoaderBusses;
        synchronized (map) {
            Iterator<Bus> iterator = classLoaderBusses.values().iterator();
            while (iterator.hasNext()) {
                Bus itBus = iterator.next();
                if (bus != null && itBus != null && !bus.equals(itBus)) continue;
                iterator.remove();
            }
        }
    }

    private static class ClassLoaderDefaultBusLifeCycleListener
    implements BusLifeCycleListener {
        private final Bus bus;

        public ClassLoaderDefaultBusLifeCycleListener(Bus bus) {
            this.bus = bus;
        }

        public void initComplete() {
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            JBossWSBusFactory.clearDefaultBusForAnyClassLoader(this.bus);
        }
    }
}

