/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.service.ConfigService;
import org.jboss.as.webservices.service.PropertyService;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

final class ClientConfigAdd
extends AbstractAddStepHandler {
    static final ClientConfigAdd INSTANCE = new ClientConfigAdd();

    private ClientConfigAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        super.rollbackRuntime(context, operation, resource);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            ServerConfig serverConfig = ASHelper.getMSCService(WSServices.CONFIG_SERVICE, ServerConfig.class, context);
            ServiceName serviceName = PackageUtils.getClientConfigServiceName(name);
            ConfigService clientConfigService = new ConfigService(serverConfig, name, true);
            ServiceTarget target = context.getServiceTarget();
            ServiceBuilder clientServiceBuilder = target.addService(serviceName, (Service)clientConfigService);
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "property")) {
                clientServiceBuilder.addDependency(sn, PropertyService.class, clientConfigService.getPropertiesInjector());
            }
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "pre-handler-chain")) {
                clientServiceBuilder.addDependency(sn, UnifiedHandlerChainMetaData.class, clientConfigService.getPreHandlerChainsInjector());
            }
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "post-handler-chain")) {
                clientServiceBuilder.addDependency(sn, UnifiedHandlerChainMetaData.class, clientConfigService.getPostHandlerChainsInjector());
            }
            clientServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        } else {
            context.reloadRequired();
        }
    }
}

