/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class DoubleFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private FieldCache.Doubles currentCache;

    public DoubleFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(AtomicReaderContext context) throws IOException {
        AtomicReader reader = context.reader();
        this.currentCache = FieldCache.DEFAULT.getDoubles(reader, this.fieldName, false);
    }

    @Override
    public Double collect(int relativeDocId) {
        return this.currentCache.get(relativeDocId);
    }
}

