/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.logging.Logger;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    public static Context createSubcontext(Context ctx, String name) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        return Util.createSubcontext(ctx, n);
    }

    public static Context createSubcontext(Context ctx, Name name) throws NamingException {
        Context subctx = ctx;
        for (int pos = 0; pos < name.size(); ++pos) {
            String ctxName = name.get(pos);
            try {
                subctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                subctx = ctx.createSubcontext(ctxName);
            }
            ctx = subctx;
        }
        return subctx;
    }

    public static void bind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        Util.bind(ctx, n, value);
    }

    public static void bind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.bind(atom, value);
    }

    public static void rebind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        Util.rebind(ctx, n, value);
    }

    public static void rebind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.rebind(atom, value);
    }

    public static void unbind(Context ctx, String name) throws NamingException {
        Util.unbind(ctx, ctx.getNameParser("").parse(name));
    }

    public static void unbind(Context ctx, Name name) throws NamingException {
        ctx.unbind(name);
        int sz = name.size();
        while (--sz > 0) {
            Name pname = name.getPrefix(sz);
            try {
                ctx.destroySubcontext(pname);
            }
            catch (NamingException e) {
                log.trace((Object)("Unable to remove context " + pname), (Throwable)e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(String name, Class<?> clazz) throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            Object object = Util.lookup((Context)ctx, name, clazz);
            return object;
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(Name name, Class<?> clazz) throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            Object object = Util.lookup((Context)ctx, name, clazz);
            return object;
        }
        finally {
            ctx.close();
        }
    }

    public static Object lookup(Context context, String name, Class clazz) throws Exception {
        Object result = context.lookup(name);
        Util.checkObject(context, name, result, clazz);
        return result;
    }

    public static Object lookup(Context context, Name name, Class clazz) throws Exception {
        Object result = context.lookup(name);
        Util.checkObject(context, name.toString(), result, clazz);
        return result;
    }

    public static void createLinkRef(String fromName, String toName) throws NamingException {
        InitialContext ctx = new InitialContext();
        Util.createLinkRef(ctx, fromName, toName);
    }

    public static void createLinkRef(Context ctx, String fromName, String toName) throws NamingException {
        LinkRef link = new LinkRef(toName);
        Context fromCtx = ctx;
        Name name = ctx.getNameParser("").parse(fromName);
        String atom = name.get(name.size() - 1);
        for (int n = 0; n < name.size() - 1; ++n) {
            String comp = name.get(n);
            try {
                fromCtx = (Context)fromCtx.lookup(comp);
                continue;
            }
            catch (NameNotFoundException e) {
                fromCtx = fromCtx.createSubcontext(comp);
            }
        }
        log.debug((Object)("atom: " + atom));
        log.debug((Object)("link: " + link));
        fromCtx.rebind(atom, (Object)link);
        log.debug((Object)("Bound link " + fromName + " to " + toName));
    }

    public static void removeLinkRef(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        Util.removeLinkRef(ctx, name);
    }

    public static void removeLinkRef(Context ctx, String name) throws NamingException {
        log.debug((Object)("Unbinding link " + name));
        ctx.unbind(name);
    }

    protected static void checkObject(Context context, String name, Object object, Class clazz) throws Exception {
        Class<?> objectClass = object.getClass();
        if (!clazz.isAssignableFrom(objectClass)) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("Object at '").append(name);
            buffer.append("' in context ").append(context.getEnvironment());
            buffer.append(" is not an instance of ");
            Util.appendClassInfo(buffer, clazz);
            buffer.append(" object class is ");
            Util.appendClassInfo(buffer, object.getClass());
            throw new ClassCastException(buffer.toString());
        }
    }

    protected static void appendClassInfo(StringBuffer buffer, Class clazz) {
        buffer.append("[class=").append(clazz.getName());
        buffer.append(" classloader=").append(clazz.getClassLoader());
        buffer.append(" interfaces={");
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("interface=").append(interfaces[i].getName());
            buffer.append(" classloader=").append(interfaces[i].getClassLoader());
        }
        buffer.append("}]");
    }
}

