/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.jms.JMSExchangeSender;

final class MessageStreamUtil {
    private MessageStreamUtil() {
    }

    public static void prepareStream(Message message, boolean isTextPayload, JMSExchangeSender sender) {
        if (isTextPayload) {
            message.setContent(Writer.class, (Object)new SendingWriter(sender, message.getExchange()));
        } else {
            SendingOutputStream out = new SendingOutputStream(sender, message.getExchange());
            message.setContent(OutputStream.class, (Object)out);
        }
    }

    public static void closeStreams(Message msg) throws IOException {
        Reader reader;
        Writer writer = (Writer)msg.getContent(Writer.class);
        if (writer != null) {
            writer.close();
        }
        if ((reader = (Reader)msg.getContent(Reader.class)) != null) {
            reader.close();
        }
    }

    private static final class SendingOutputStream
    extends CachedOutputStream {
        private final JMSExchangeSender sender;
        private Exchange exchange;

        public SendingOutputStream(JMSExchangeSender sender, Exchange exchange) {
            this.sender = sender;
            this.exchange = exchange;
        }

        protected void doClose() throws IOException {
            this.sender.sendExchange(this.exchange, this.getBytes());
        }
    }

    private static final class SendingWriter
    extends StringWriter {
        private final JMSExchangeSender sender;
        private Exchange exchange;

        private SendingWriter(JMSExchangeSender sender, Exchange exchange) {
            this.sender = sender;
            this.exchange = exchange;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.sender.sendExchange(this.exchange, this.toString());
        }
    }
}

