/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.security.cache.CXFEHCacheReplayCache;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.cache.ReplayCacheFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;

public final class WSS4JUtils {
    private WSS4JUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplayCache getReplayCache(SoapMessage message, String booleanKey, String instanceKey) {
        boolean specified = false;
        Object o = message.getContextualProperty(booleanKey);
        if (o != null) {
            if (!MessageUtils.isTrue((Object)o)) {
                return null;
            }
            specified = true;
        }
        if (!specified && MessageUtils.isRequestor((Message)message)) {
            return null;
        }
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        if (ep != null && ep.getEndpointInfo() != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = ep.getEndpointInfo();
            synchronized (endpointInfo) {
                Object replayCache = (ReplayCache)message.getContextualProperty(instanceKey);
                if (replayCache == null) {
                    replayCache = (ReplayCache)info.getProperty(instanceKey);
                }
                if (replayCache == null) {
                    String cacheKey = instanceKey;
                    if (info.getName() != null) {
                        int hashcode = info.getName().toString().hashCode();
                        cacheKey = hashcode < 0 ? cacheKey + hashcode : cacheKey + "-" + hashcode;
                    }
                    URL configFile = WSS4JUtils.getConfigFileURL((Message)message);
                    if (ReplayCacheFactory.isEhCacheInstalled()) {
                        Bus bus = message.getExchange().getBus();
                        replayCache = new CXFEHCacheReplayCache(cacheKey, bus, configFile);
                    } else {
                        ReplayCacheFactory replayCacheFactory = ReplayCacheFactory.newInstance();
                        replayCache = replayCacheFactory.newReplayCache(cacheKey, (Object)configFile);
                    }
                    info.setProperty(instanceKey, replayCache);
                }
                return replayCache;
            }
        }
        return null;
    }

    private static URL getConfigFileURL(Message message) {
        Object o = message.getContextualProperty("ws-security.cache.config.file");
        if (o == null) {
            o = "/cxf-ehcache.xml";
        }
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), ReplayCacheFactory.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    public static TokenStore getTokenStore(Message message) {
        return WSS4JUtils.getTokenStore(message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenStore getTokenStore(Message message, boolean create) {
        EndpointInfo info;
        EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
        synchronized (endpointInfo) {
            TokenStore tokenStore = (TokenStore)message.getContextualProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            if (tokenStore == null) {
                tokenStore = (TokenStore)info.getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
            }
            if (create && tokenStore == null) {
                TokenStoreFactory tokenStoreFactory = TokenStoreFactory.newInstance();
                String cacheKey = "org.apache.cxf.ws.security.tokenstore.TokenStore";
                String cacheIdentifier = (String)message.getContextualProperty("ws-security.cache.identifier");
                if (cacheIdentifier != null) {
                    cacheKey = cacheKey + "-" + cacheIdentifier;
                } else if (info.getName() != null) {
                    int hashcode = info.getName().toString().hashCode();
                    cacheKey = hashcode < 0 ? cacheKey + hashcode : cacheKey + "-" + hashcode;
                }
                tokenStore = tokenStoreFactory.newTokenStore(cacheKey, message);
                info.setProperty("org.apache.cxf.ws.security.tokenstore.TokenStore", (Object)tokenStore);
            }
            return tokenStore;
        }
    }

    public static String parseAndStoreStreamingSecurityToken(org.apache.xml.security.stax.securityToken.SecurityToken securityToken, Message message) throws XMLSecurityException {
        if (securityToken == null) {
            return null;
        }
        SecurityToken existingToken = WSS4JUtils.getTokenStore(message).getToken(securityToken.getId());
        if (existingToken == null || existingToken.isExpired()) {
            Date created = new Date();
            Date expires = new Date();
            expires.setTime(created.getTime() + 300000L);
            SecurityToken cachedTok = new SecurityToken(securityToken.getId(), created, expires);
            cachedTok.setSHA1(securityToken.getSha1Identifier());
            if (securityToken.getTokenType() != null) {
                if (securityToken.getTokenType() == WSSecurityTokenConstants.EncryptedKeyToken) {
                    cachedTok.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                } else if (securityToken.getTokenType() == WSSecurityTokenConstants.KerberosToken) {
                    cachedTok.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
                } else if (securityToken.getTokenType() == WSSecurityTokenConstants.Saml11Token) {
                    cachedTok.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
                } else if (securityToken.getTokenType() == WSSecurityTokenConstants.Saml20Token) {
                    cachedTok.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
                } else if (securityToken.getTokenType() == WSSecurityTokenConstants.SecureConversationToken || securityToken.getTokenType() == WSSecurityTokenConstants.SecurityContextToken) {
                    cachedTok.setTokenType("http://schemas.xmlsoap.org/ws/2005/02/sc");
                }
            }
            for (String key : securityToken.getSecretKey().keySet()) {
                Key keyObject = (Key)securityToken.getSecretKey().get(key);
                if (keyObject == null) continue;
                cachedTok.setKey(keyObject);
                if (!(keyObject instanceof SecretKey)) break;
                cachedTok.setSecret(keyObject.getEncoded());
                break;
            }
            WSS4JUtils.getTokenStore(message).add(cachedTok);
            return cachedTok.getId();
        }
        return existingToken.getId();
    }

    public static SoapFault createSoapFault(SoapMessage message, SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        String errorMessage = null;
        QName faultCode = null;
        boolean returnSecurityError = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.return.security.error", (boolean)false);
        if (returnSecurityError || MessageUtils.isRequestor((Message)message)) {
            errorMessage = e.getMessage();
            faultCode = e.getFaultCode();
        } else {
            errorMessage = e.getSafeExceptionMessage();
            faultCode = e.getSafeFaultCode();
        }
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(errorMessage, (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(errorMessage, (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }
}

