/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.factories;

import java.security.Principal;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.picketlink.identity.federation.core.constants.PicketLinkFederationConstants;
import org.picketlink.identity.federation.core.factories.SecurityActions;

public class JBossAuthCacheInvalidationFactory {
    public static TimeCacheExpiry getCacheExpiry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkFederationConstants.RUNTIME_PERMISSION_CORE);
        }
        return ExpiringPrincipalCacheInvalidation.get();
    }

    protected static class ExpiringPrincipalCacheInvalidation
    implements TimeCacheExpiry {
        private static Logger log = Logger.getLogger(ExpiringPrincipalCacheInvalidation.class);
        private final boolean trace = log.isTraceEnabled();
        protected static ExpiringPrincipalCacheInvalidation _instance = null;
        protected static String objectName = "jboss.security:service=JaasSecurityManager";
        protected static Timer timer = new Timer();

        protected ExpiringPrincipalCacheInvalidation() {
        }

        protected static ExpiringPrincipalCacheInvalidation get() {
            if (_instance == null) {
                _instance = new ExpiringPrincipalCacheInvalidation();
            }
            return _instance;
        }

        protected static void setObjectName(String oName) {
            objectName = oName;
        }

        @Override
        public void register(final String securityDomain, Date expiry, final Principal principal) {
            block5: {
                block4: {
                    try {
                        timer.purge();
                    }
                    catch (Exception e) {
                        if (!this.trace) break block4;
                        log.trace((Object)"Exception in purging timer tasks:", (Throwable)e);
                    }
                }
                try {
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    ObjectName on = new ObjectName(objectName);
                                    MBeanServer server = SecurityActions.getJBossMBeanServer();
                                    Object[] obj = new Object[]{securityDomain, principal};
                                    String[] sig = new String[]{"java.lang.String", "java.security.Principal"};
                                    server.invoke(on, "flushAuthenticationCache", obj, sig);
                                }
                                catch (Exception e) {
                                    if (!ExpiringPrincipalCacheInvalidation.this.trace) break block2;
                                    log.trace((Object)"Exception in scheduling timer:", (Throwable)e);
                                }
                            }
                        }
                    }, expiry);
                }
                catch (Exception e) {
                    if (!this.trace) break block5;
                    log.trace((Object)"Exception in scheduling timer:", (Throwable)e);
                }
            }
        }
    }

    public static interface TimeCacheExpiry {
        public void register(String var1, Date var2, Principal var3);
    }
}

