/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.SAMLHandlerChainProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;

public class ServiceProviderSAMLResponseProcessor
extends ServiceProviderBaseProcessor {
    private boolean idpPostBinding = false;

    public void setIdpPostBinding(boolean idpPostBinding) {
        this.idpPostBinding = idpPostBinding;
    }

    public ServiceProviderSAMLResponseProcessor(boolean postBinding, String serviceURL, PicketLinkType picketLinkType) {
        super(postBinding, serviceURL, picketLinkType);
    }

    public ServiceProviderSAMLResponseProcessor(boolean postBinding, String serviceURL, PicketLinkType picketLinkType, IDPSSODescriptorType idpMetadata) {
        super(postBinding, serviceURL, picketLinkType, idpMetadata);
    }

    public SAML2HandlerResponse process(String samlResponse, HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        SAMLDocumentHolder documentHolder = this.getSAMLDocumentHolder(samlResponse);
        SAML2HandlerResponse saml2HandlerResponse = this.processHandlersChain(httpContext, handlers, chainLock, documentHolder);
        return saml2HandlerResponse;
    }

    private SAML2HandlerResponse processHandlersChain(HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock, SAMLDocumentHolder documentHolder) throws ConfigurationException, ProcessingException, IOException {
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(documentHolder, httpContext);
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        SAMLHandlerChainProcessor chainProcessor = new SAMLHandlerChainProcessor(handlers, this.configuration);
        this.setRequestOptions(saml2HandlerRequest);
        saml2HandlerRequest.addOption("CONTEXT_PATH", httpContext.getServletContext().getContextPath());
        saml2HandlerRequest.addOption("SUPPORTS_SIGNATURES", this.getSpConfiguration().isSupportsSignature());
        chainProcessor.callHandlerChain(documentHolder.getSamlObject(), saml2HandlerRequest, saml2HandlerResponse, httpContext, chainLock);
        return saml2HandlerResponse;
    }

    private boolean isPostBinding() {
        return this.postBinding || this.idpPostBinding;
    }

    private SAMLDocumentHolder getSAMLDocumentHolder(String samlResponse) throws ParsingException, ConfigurationException, ProcessingException {
        SAML2Response saml2Response = new SAML2Response();
        InputStream dataStream = null;
        dataStream = this.isPostBinding() ? PostBindingUtil.base64DecodeAsStream(samlResponse) : RedirectBindingUtil.base64DeflateDecode(samlResponse);
        try {
            saml2Response.getSAML2ObjectFromStream(dataStream);
        }
        catch (ProcessingException pe) {
            logger.samlResponseFromIDPParsingFailed();
            throw pe;
        }
        catch (ParsingException pe) {
            logger.samlResponseFromIDPParsingFailed();
            throw pe;
        }
        return saml2Response.getSamlDocumentHolder();
    }
}

