/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.wildfly.extension.undertow.deployment.SecurityActions;
import org.wildfly.extension.undertow.security.AccountImpl;

public class LogoutNotificationReceiver
implements NotificationReceiver {
    private final AuthenticationManager manager;

    public LogoutNotificationReceiver(AuthenticationManager manager) {
        this.manager = manager;
    }

    public void handleNotification(SecurityNotification notification) {
        if (notification.getEventType() == SecurityNotification.EventType.LOGGED_OUT) {
            Principal principal;
            Account account = notification.getAccount();
            Principal principal2 = principal = account instanceof AccountImpl ? ((AccountImpl)account).getOriginalPrincipal() : account.getPrincipal();
            if (principal != null) {
                Subject subject = SecurityActions.getSubject();
                this.manager.logout(principal, subject);
            }
        }
    }
}

