/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.io.IOException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterService;
import org.wildfly.extension.undertow.filters.ModClusterDefinition;
import org.xnio.XnioWorker;

public class ModClusterService
extends FilterService {
    private final InjectedValue<XnioWorker> workerInjectedValue = new InjectedValue();
    private final InjectedValue<SocketBinding> managementSocketBinding = new InjectedValue();
    private final InjectedValue<SocketBinding> advertiseSocketBinding = new InjectedValue();
    private final long healthCheckInterval;
    private final int maxRequestTime;
    private final long removeBrokenNodes;
    private final int advertiseFrequency;
    private final String advertisePath;
    private final String advertiseProtocol;
    private final String securityKey;
    private final Predicate managementAccessPredicate;
    private final int connectionsPerThread;
    private final int cachedConnections;
    private final int connectionIdleTimeout;
    private final int requestQueueSize;
    private ModCluster modCluster;
    private MCMPConfig config;

    ModClusterService(ModelNode model, long healthCheckInterval, int maxRequestTime, long removeBrokenNodes, int advertiseFrequency, String advertisePath, String advertiseProtocol, String securityKey, Predicate managementAccessPredicate, int connectionsPerThread, int cachedConnections, int connectionIdleTimeout, int requestQueueSize) {
        super(ModClusterDefinition.INSTANCE, model);
        this.healthCheckInterval = healthCheckInterval;
        this.maxRequestTime = maxRequestTime;
        this.removeBrokenNodes = removeBrokenNodes;
        this.advertiseFrequency = advertiseFrequency;
        this.advertisePath = advertisePath;
        this.advertiseProtocol = advertiseProtocol;
        this.securityKey = securityKey;
        this.managementAccessPredicate = managementAccessPredicate;
        this.connectionsPerThread = connectionsPerThread;
        this.cachedConnections = cachedConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.requestQueueSize = requestQueueSize;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        super.start(context);
        this.modCluster = ModCluster.builder((XnioWorker)((XnioWorker)this.workerInjectedValue.getValue())).setHealthCheckInterval(this.healthCheckInterval).setMaxRequestTime(this.maxRequestTime).setCacheConnections(this.cachedConnections).setQueueNewRequests(this.requestQueueSize > 0).setRequestQueueSize(this.requestQueueSize).setRemoveBrokenNodes(this.removeBrokenNodes).build();
        MCMPConfig.Builder builder = MCMPConfig.builder();
        builder.enableAdvertise().setAdvertiseAddress(((SocketBinding)this.advertiseSocketBinding.getValue()).getSocketAddress().getAddress().getHostAddress()).setAdvertiseGroup(((SocketBinding)this.advertiseSocketBinding.getValue()).getMulticastAddress().getHostAddress()).setAdvertisePort(((SocketBinding)this.advertiseSocketBinding.getValue()).getPort()).setAdvertiseFrequency(this.advertiseFrequency).setPath(this.advertisePath).setProtocol(this.advertiseProtocol).setSecurityKey(this.securityKey);
        builder.setManagementHost(((SocketBinding)this.managementSocketBinding.getValue()).getSocketAddress().getHostName());
        builder.setManagementPort(((SocketBinding)this.managementSocketBinding.getValue()).getSocketAddress().getPort());
        this.config = builder.build();
        try {
            this.modCluster.advertise(this.config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.modCluster.start();
    }

    @Override
    public synchronized void stop(StopContext context) {
        super.stop(context);
        this.modCluster.stop();
        this.modCluster = null;
        this.config = null;
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, HttpHandler next) {
        final HttpHandler mcmp = this.managementAccessPredicate != null ? Handlers.predicate((Predicate)this.managementAccessPredicate, (HttpHandler)this.config.create(this.modCluster, next), (HttpHandler)next) : this.config.create(this.modCluster, next);
        final HttpHandler proxyHandler = this.modCluster.getProxyHandler();
        HttpHandler theHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                proxyHandler.handleRequest(exchange);
                if (!exchange.isDispatched() && !exchange.isComplete()) {
                    exchange.setResponseCode(200);
                    mcmp.handleRequest(exchange);
                }
            }
        };
        if (predicate != null) {
            return new PredicateHandler(predicate, theHandler, next);
        }
        return theHandler;
    }

    static ServiceController<FilterService> install(String name, ServiceTarget serviceTarget, ModelNode model, OperationContext operationContext) throws OperationFailedException {
        String securityKey = null;
        ModelNode securityKeyNode = ModClusterDefinition.SECURITY_KEY.resolveModelAttribute(operationContext, model);
        if (securityKeyNode.isDefined()) {
            securityKey = securityKeyNode.asString();
        }
        String managementAccessPredicateString = null;
        ModelNode managementAccessPredicateNode = ModClusterDefinition.MANAGEMENT_ACCESS_PREDICATE.resolveModelAttribute(operationContext, model);
        if (managementAccessPredicateNode.isDefined()) {
            managementAccessPredicateString = managementAccessPredicateNode.asString();
        }
        Predicate managementAccessPredicate = null;
        if (managementAccessPredicateString != null) {
            managementAccessPredicate = PredicateParser.parse((String)managementAccessPredicateString, (ClassLoader)ModClusterService.class.getClassLoader());
        }
        ModClusterService service = new ModClusterService(model, ModClusterDefinition.HEALTH_CHECK_INTERVAL.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.MAX_REQUEST_TIME.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.BROKEN_NODE_TIMEOUT.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.ADVERTISE_FREQUENCY.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.ADVERTISE_PATH.resolveModelAttribute(operationContext, model).asString(), ModClusterDefinition.ADVERTISE_PROTOCOL.resolveModelAttribute(operationContext, model).asString(), securityKey, managementAccessPredicate, ModClusterDefinition.CONNECTIONS_PER_THREAD.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.CACHED_CONNECTIONS_PER_THREAD.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.CONNECTION_IDLE_TIMEOUT.resolveModelAttribute(operationContext, model).asInt(), ModClusterDefinition.REQUEST_QUEUE_SIZE.resolveModelAttribute(operationContext, model).asInt());
        ServiceBuilder builder = serviceTarget.addService(UndertowService.FILTER.append(new String[]{name}), (Service)service);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{ModClusterDefinition.MANAGEMENT_SOCKET_BINDING.resolveModelAttribute(operationContext, model).asString()}), SocketBinding.class, service.managementSocketBinding);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{ModClusterDefinition.ADVERTISE_SOCKET_BINDING.resolveModelAttribute(operationContext, model).asString()}), SocketBinding.class, service.advertiseSocketBinding);
        builder.addDependency(IOServices.WORKER.append(new String[]{ModClusterDefinition.WORKER.resolveModelAttribute(operationContext, model).asString()}), XnioWorker.class, service.workerInjectedValue);
        return builder.install();
    }
}

