/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.util.Headers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.handlers.Handler;
import org.wildfly.extension.undertow.handlers.ReverseProxyHandlerHost;

public class ReverseProxyHandler
extends Handler {
    public static final AttributeDefinition PROBLEM_SERVER_RETRY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("problem-server-retry", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(30))).build();
    public static final AttributeDefinition SESSION_COOKIE_NAMES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-cookie-names", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode("JSESSIONID"))).build();
    public static final AttributeDefinition CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connections-per-thread", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).build();
    public static final AttributeDefinition MAX_REQUEST_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-request-time", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).build();
    public static final AttributeDefinition REQUEST_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-queue-size", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).build();
    public static final AttributeDefinition CACHED_CONNECTIONS_PER_THREAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cached-connections-per-thread", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(5))).build();
    public static final AttributeDefinition CONNECTION_IDLE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-idle-timeout", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(60L))).build();
    public static final ReverseProxyHandler INSTANCE = new ReverseProxyHandler();

    private ReverseProxyHandler() {
        super("reverse-proxy");
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(CONNECTIONS_PER_THREAD, SESSION_COOKIE_NAMES, PROBLEM_SERVER_RETRY, REQUEST_QUEUE_SIZE, MAX_REQUEST_TIME, CACHED_CONNECTIONS_PER_THREAD, CONNECTION_IDLE_TIMEOUT);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.singletonList(ReverseProxyHandlerHost.INSTANCE);
    }

    @Override
    public HttpHandler createHandler(OperationContext context, ModelNode model) throws OperationFailedException {
        String[] sessionIds;
        String sessionCookieNames = SESSION_COOKIE_NAMES.resolveModelAttribute(context, model).asString();
        int connectionsPerThread = CONNECTIONS_PER_THREAD.resolveModelAttribute(context, model).asInt();
        int problemServerRetry = PROBLEM_SERVER_RETRY.resolveModelAttribute(context, model).asInt();
        int maxTime = MAX_REQUEST_TIME.resolveModelAttribute(context, model).asInt();
        int requestQueueSize = REQUEST_QUEUE_SIZE.resolveModelAttribute(context, model).asInt();
        int cachedConnectionsPerThread = CACHED_CONNECTIONS_PER_THREAD.resolveModelAttribute(context, model).asInt();
        int connectionIdleTimeout = CONNECTION_IDLE_TIMEOUT.resolveModelAttribute(context, model).asInt();
        LoadBalancingProxyClient lb = new LoadBalancingProxyClient(new ExclusivityChecker(){

            public boolean isExclusivityRequired(HttpServerExchange exchange) {
                return exchange.getRequestHeaders().contains(Headers.UPGRADE);
            }
        }).setConnectionsPerThread(connectionsPerThread).setMaxQueueSize(requestQueueSize).setProblemServerRetry(problemServerRetry);
        for (String id : sessionIds = sessionCookieNames.split(",")) {
            lb.addSessionCookieName(id);
        }
        ProxyHandler handler = new ProxyHandler((ProxyClient)lb, maxTime, (HttpHandler)ResponseCodeHandler.HANDLE_404);
        return handler;
    }
}

