/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.dmr.ModelNode;

public class AddAliasHandler
implements OperationStepHandler {
    private final ParametersValidator nameValidator = new ParametersValidator();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String newAlias = Operations.getAttributeName((ModelNode)operation);
        ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        ModelNode currentValue = submodel.get(CacheContainerResourceDefinition.ALIASES.getName()).clone();
        ModelNode newValue = AddAliasHandler.addNewAliasToList(currentValue, newAlias);
        ModelNode syntheticOp = new ModelNode();
        syntheticOp.get(CacheContainerResourceDefinition.ALIASES.getName()).set(newValue);
        CacheContainerResourceDefinition.ALIASES.validateAndSet(syntheticOp, submodel);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType().isServer() && !context.isBooting();
    }

    private static ModelNode addNewAliasToList(ModelNode list, String alias) {
        if (alias == null || alias.equals("")) {
            return list;
        }
        if (!list.isDefined()) {
            list.setEmptyList();
        }
        ModelNode newList = list.clone();
        List listElements = list.asList();
        boolean found = false;
        for (ModelNode listElement : listElements) {
            if (!listElement.asString().equals(alias)) continue;
            found = true;
        }
        if (!found) {
            newList.add().set(alias);
        }
        return newList;
    }
}

