/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.xsite.XSiteAdminOperations;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteOperationContext;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;

public class BackupSiteOperationHandler
extends AbstractRuntimeOnlyHandler {
    private final Operation<BackupSiteOperationContext> operation;

    public BackupSiteOperationHandler(Operation<BackupSiteOperationContext> operation) {
        this.operation = operation;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String cacheContainerName = address.getElement(address.size() - 3).getValue();
        String cacheName = address.getElement(address.size() - 2).getValue();
        final String site = address.getElement(address.size() - 1).getValue();
        ServiceName cacheServiceName = CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName);
        ServiceController controller = context.getServiceRegistry(true).getService(cacheServiceName);
        final Cache cache = (Cache)controller.getValue();
        try {
            BackupSiteOperationContext operationContext = new BackupSiteOperationContext(){

                @Override
                public String getSite() {
                    return site;
                }

                @Override
                public XSiteAdminOperations getOperations() {
                    return (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
                }
            };
            ModelNode result = this.operation.getValue((Object)operationContext);
            if (result != null) {
                context.getResult().set(result);
            }
        }
        catch (Exception e) {
            throw InfinispanLogger.ROOT_LOGGER.failedToInvokeOperation(e.getCause(), this.operation.getDefinition().getName());
        }
    }
}

