/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetric;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;

public class CacheMetricsHandler
extends AbstractRuntimeOnlyHandler {
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        PathAddress address = context.getCurrentAddress();
        String containerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        String name = Operations.getAttributeName((ModelNode)operation);
        CacheMetric metric = CacheMetric.forName(name);
        if (metric == null) {
            context.getFailureDescription().set(InfinispanLogger.ROOT_LOGGER.unknownMetric(name));
        } else {
            Cache cache = (Cache)ServiceContainerHelper.findValue((ServiceRegistry)context.getServiceRegistry(false), (ServiceName)CacheServiceName.CACHE.getServiceName(containerName, cacheName));
            if (cache != null) {
                context.getResult().set(metric.getValue(cache));
            }
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

