/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Map;
import org.jboss.as.clustering.controller.validation.DoubleRangeValidatorBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheType;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.SegmentsAndVirtualNodeConverter;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DefaultCheckersAndConverter;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DistributedCacheResourceDefinition
extends SharedStateCacheResourceDefinition {
    static final SimpleAttributeDefinition L1_LIFESPAN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("l1-lifespan", ModelType.LONG, true).setXmlName(Attribute.L1_LIFESPAN.getLocalName())).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(600000L))).build();
    static final SimpleAttributeDefinition OWNERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("owners", ModelType.INT, true).setXmlName(Attribute.OWNERS.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(2))).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).build();
    @Deprecated
    static final SimpleAttributeDefinition VIRTUAL_NODES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("virtual-nodes", ModelType.INT, true).setXmlName(Attribute.VIRTUAL_NODES.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(1))).setDeprecated(InfinispanModel.VERSION_1_4_0.getVersion())).setAlternatives(new String[]{"segments"})).build();
    static final SimpleAttributeDefinition SEGMENTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("segments", ModelType.INT, true).setXmlName(Attribute.SEGMENTS.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(80))).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).setAlternatives(new String[]{"virtual-nodes"})).build();
    static final SimpleAttributeDefinition CAPACITY_FACTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("capacity-factor", ModelType.DOUBLE, true).setXmlName(Attribute.CAPACITY_FACTOR.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(1.0))).setValidator(new DoubleRangeValidatorBuilder().lowerBound(0.0).upperBound(3.4028234663852886E38).build())).build();
    static final SimpleAttributeDefinition CONSISTENT_HASH_STRATEGY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("consistent-hash-strategy", ModelType.STRING, true).setXmlName(Attribute.CONSISTENT_HASH_STRATEGY.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode(ConsistentHashStrategy.DEFAULT.name()))).setValidator((ParameterValidator)new EnumValidator(ConsistentHashStrategy.class, true, true))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{OWNERS, SEGMENTS, L1_LIFESPAN, CAPACITY_FACTOR, CONSISTENT_HASH_STRATEGY};

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(CacheType.DISTRIBUTED.pathElement());
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{CAPACITY_FACTOR.getDefaultValue()}), new AttributeDefinition[]{CAPACITY_FACTOR})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CAPACITY_FACTOR})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{CONSISTENT_HASH_STRATEGY.getDefaultValue()}), new AttributeDefinition[]{CONSISTENT_HASH_STRATEGY})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{CONSISTENT_HASH_STRATEGY})).end();
        }
        if (InfinispanModel.VERSION_1_4_0.requiresTransformation(version)) {
            AttributeConverter.DefaultAttributeConverter converter = new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    if (attributeValue.isDefined()) {
                        attributeValue.set(SegmentsAndVirtualNodeConverter.segmentsToVirtualNodes(attributeValue.asString()));
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{SEGMENTS})).setValueConverter((AttributeConverter)converter, new AttributeDefinition[]{SEGMENTS})).addRename((AttributeDefinition)SEGMENTS, VIRTUAL_NODES.getName())).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{L1_LIFESPAN, OWNERS, VIRTUAL_NODES, SEGMENTS})).end();
        } else if (InfinispanModel.VERSION_1_4_1.requiresTransformation(version)) {
            DiscardAttributeChecker.DefaultDiscardAttributeChecker checker = new DiscardAttributeChecker.DefaultDiscardAttributeChecker(false, true){

                protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    return attributeValue.isDefined() && attributeValue.equals(new ModelNode(1));
                }
            };
            DefaultCheckersAndConverter checkersAndConverter = new DefaultCheckersAndConverter(){

                public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                    return InfinispanLogger.ROOT_LOGGER.segmentsDoesNotSupportExpressions();
                }

                protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    return this.checkForExpression(attributeValue);
                }

                protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    if (attributeValue.isDefined()) {
                        attributeValue.set(SegmentsAndVirtualNodeConverter.virtualNodesToSegments(attributeValue));
                    }
                }

                protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    return false;
                }
            };
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)checker, new AttributeDefinition[]{VIRTUAL_NODES})).addRejectCheck((RejectAttributeChecker)checkersAndConverter, new AttributeDefinition[]{VIRTUAL_NODES})).setValueConverter((AttributeConverter)checkersAndConverter, new AttributeDefinition[]{VIRTUAL_NODES})).addRename((AttributeDefinition)VIRTUAL_NODES, SEGMENTS.getName())).end();
        }
        SharedStateCacheResourceDefinition.buildTransformation(version, builder);
    }

    DistributedCacheResourceDefinition(PathManager pathManager, boolean allowRuntimeOnlyRegistration) {
        super(CacheType.DISTRIBUTED, pathManager, allowRuntimeOnlyRegistration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        OperationStepHandler virtualNodesWriteHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (operation.hasDefined("value") && operation.get("value").asInt() != 1) {
                    InfinispanLogger.ROOT_LOGGER.virtualNodesAttributeDeprecated();
                    ModelNode convertedValue = SegmentsAndVirtualNodeConverter.virtualNodesToSegments(operation.get("value"));
                    ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
                    ModelNode syntheticOp = new ModelNode();
                    syntheticOp.get("segments").set(convertedValue);
                    SEGMENTS.validateAndSet(syntheticOp, submodel);
                    if (this.requiresRuntime(context)) {
                        context.addStep(new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) {
                                context.reloadRequired();
                                context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                            }
                        }, OperationContext.Stage.RUNTIME);
                    }
                }
            }

            protected boolean requiresRuntime(OperationContext context) {
                return context.getProcessType().isServer() && !context.isBooting();
            }
        };
        registration.registerReadWriteAttribute((AttributeDefinition)VIRTUAL_NODES, null, virtualNodesWriteHandler);
    }
}

