/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.interceptors.CacheMgmtInterceptor;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum EvictionMetric implements Metric<Cache<?, ?>>
{
    EVICTIONS("evictions", ModelType.LONG){

        public ModelNode getValue(Cache<?, ?> cache) {
            CacheMgmtInterceptor interceptor = CacheMetric.findInterceptor(cache, CacheMgmtInterceptor.class);
            return new ModelNode(interceptor != null ? interceptor.getEvictions() : 0L);
        }
    };

    private final AttributeDefinition definition;
    private static final Map<String, EvictionMetric> metrics;

    private EvictionMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static EvictionMetric forName(String name) {
        return metrics.get(name);
    }

    static {
        metrics = new HashMap<String, EvictionMetric>();
        for (EvictionMetric metric : EvictionMetric.values()) {
            metrics.put(metric.definition.getName(), metric);
        }
    }
}

