/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheType;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final XMLElementWriter<SubsystemMarshallingContext> INSTANCE = new InfinispanSubsystemXMLWriter();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(InfinispanSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined() && model.hasDefined(CacheContainerResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property entry : model.get(CacheContainerResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                ModelNode cache;
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), containerName);
                CacheContainerResourceDefinition.DEFAULT_CACHE.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.EVICTION_EXECUTOR.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.JNDI_NAME.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.LISTENER_EXECUTOR.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.REPLICATION_QUEUE_EXECUTOR.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.START.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.MODULE.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.STATISTICS_ENABLED.marshallAsAttribute(container, (XMLStreamWriter)writer);
                CacheContainerResourceDefinition.ALIASES.marshallAsElement(container, (XMLStreamWriter)writer);
                if (container.hasDefined(TransportResourceDefinition.PATH.getKey())) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(TransportResourceDefinition.PATH.getKeyValuePair());
                    TransportResourceDefinition.CHANNEL.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                    TransportResourceDefinition.EXECUTOR.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                    TransportResourceDefinition.LOCK_TIMEOUT.marshallAsAttribute(transport, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                if (container.hasDefined(CacheType.LOCAL.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.LOCAL.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.LOCAL_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(CacheType.INVALIDATION.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.INVALIDATION.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.INVALIDATION_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(CacheType.REPLICATED.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.REPLICATED.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.REPLICATED_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                if (container.hasDefined(CacheType.DISTRIBUTED.pathElement().getKey())) {
                    for (Property property : container.get(CacheType.DISTRIBUTED.pathElement().getKey()).asPropertyList()) {
                        cache = property.getValue();
                        writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
                        InfinispanSubsystemXMLWriter.writeClusteredCacheAttributes(writer, property.getName(), cache);
                        DistributedCacheResourceDefinition.OWNERS.marshallAsAttribute(cache, (XMLStreamWriter)writer);
                        DistributedCacheResourceDefinition.SEGMENTS.marshallAsAttribute(cache, (XMLStreamWriter)writer);
                        DistributedCacheResourceDefinition.L1_LIFESPAN.marshallAsAttribute(cache, (XMLStreamWriter)writer);
                        DistributedCacheResourceDefinition.CAPACITY_FACTOR.marshallAsAttribute(cache, (XMLStreamWriter)writer);
                        DistributedCacheResourceDefinition.CONSISTENT_HASH_STRATEGY.marshallAsAttribute(cache, (XMLStreamWriter)writer);
                        InfinispanSubsystemXMLWriter.writeCacheElements(writer, cache);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        CacheResourceDefinition.START.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        CacheResourceDefinition.JNDI_NAME.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        CacheResourceDefinition.MODULE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        CacheResourceDefinition.STATISTICS_ENABLED.marshallAsAttribute(cache, (XMLStreamWriter)writer);
    }

    private static void writeClusteredCacheAttributes(XMLExtendedStreamWriter writer, String name, ModelNode cache) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeCacheAttributes(writer, name, cache);
        ClusteredCacheResourceDefinition.ASYNC_MARSHALLING.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        ClusteredCacheResourceDefinition.MODE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        ClusteredCacheResourceDefinition.QUEUE_SIZE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        ClusteredCacheResourceDefinition.QUEUE_FLUSH_INTERVAL.marshallAsAttribute(cache, (XMLStreamWriter)writer);
        ClusteredCacheResourceDefinition.REMOTE_TIMEOUT.marshallAsAttribute(cache, (XMLStreamWriter)writer);
    }

    private static void writeCacheElements(XMLExtendedStreamWriter writer, ModelNode cache) throws XMLStreamException {
        ModelNode store;
        if (cache.hasDefined(LockingResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.LOCKING.getLocalName());
            ModelNode locking = cache.get(LockingResourceDefinition.PATH.getKeyValuePair());
            LockingResourceDefinition.ISOLATION.marshallAsAttribute(locking, (XMLStreamWriter)writer);
            LockingResourceDefinition.STRIPING.marshallAsAttribute(locking, (XMLStreamWriter)writer);
            LockingResourceDefinition.ACQUIRE_TIMEOUT.marshallAsAttribute(locking, (XMLStreamWriter)writer);
            LockingResourceDefinition.CONCURRENCY_LEVEL.marshallAsAttribute(locking, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined(TransactionResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.TRANSACTION.getLocalName());
            ModelNode transaction = cache.get(TransactionResourceDefinition.PATH.getKeyValuePair());
            TransactionResourceDefinition.STOP_TIMEOUT.marshallAsAttribute(transaction, (XMLStreamWriter)writer);
            TransactionResourceDefinition.MODE.marshallAsAttribute(transaction, (XMLStreamWriter)writer);
            TransactionResourceDefinition.LOCKING.marshallAsAttribute(transaction, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined(EvictionResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.EVICTION.getLocalName());
            ModelNode eviction = cache.get(EvictionResourceDefinition.PATH.getKeyValuePair());
            EvictionResourceDefinition.STRATEGY.marshallAsAttribute(eviction, (XMLStreamWriter)writer);
            EvictionResourceDefinition.MAX_ENTRIES.marshallAsAttribute(eviction, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined(ExpirationResourceDefinition.PATH.getKey())) {
            writer.writeStartElement(Element.EXPIRATION.getLocalName());
            ModelNode expiration = cache.get(ExpirationResourceDefinition.PATH.getKeyValuePair());
            ExpirationResourceDefinition.MAX_IDLE.marshallAsAttribute(expiration, (XMLStreamWriter)writer);
            ExpirationResourceDefinition.LIFESPAN.marshallAsAttribute(expiration, (XMLStreamWriter)writer);
            ExpirationResourceDefinition.INTERVAL.marshallAsAttribute(expiration, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined(CustomStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(CustomStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.STORE.getLocalName());
            CustomStoreResourceDefinition.CLASS.marshallAsAttribute(store, (XMLStreamWriter)writer);
            InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(FileStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(FileStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.FILE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
            FileStoreResourceDefinition.RELATIVE_TO.marshallAsAttribute(store, (XMLStreamWriter)writer);
            FileStoreResourceDefinition.RELATIVE_PATH.marshallAsAttribute(store, (XMLStreamWriter)writer);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StringKeyedJDBCStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(StringKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.STRING_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeJDBCStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
            writer.writeEndElement();
        }
        if (cache.hasDefined(BinaryKeyedJDBCStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(BinaryKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.BINARY_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeJDBCStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
            writer.writeEndElement();
        }
        if (cache.hasDefined(MixedKeyedJDBCStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(MixedKeyedJDBCStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.MIXED_KEYED_JDBC_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeJDBCStoreAttributes(writer, store);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
            InfinispanSubsystemXMLWriter.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
            writer.writeEndElement();
        }
        if (cache.hasDefined(RemoteStoreResourceDefinition.PATH.getKey())) {
            store = cache.get(RemoteStoreResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.REMOTE_STORE.getLocalName());
            InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
            RemoteStoreResourceDefinition.CACHE.marshallAsAttribute(store, (XMLStreamWriter)writer);
            RemoteStoreResourceDefinition.SOCKET_TIMEOUT.marshallAsAttribute(store, (XMLStreamWriter)writer);
            RemoteStoreResourceDefinition.TCP_NO_DELAY.marshallAsAttribute(store, (XMLStreamWriter)writer);
            InfinispanSubsystemXMLWriter.writeStoreElements(writer, store);
            for (ModelNode remoteServer : store.get("remote-servers").asList()) {
                writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                RemoteStoreResourceDefinition.OUTBOUND_SOCKET_BINDING.marshallAsAttribute(remoteServer, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.get("indexing").isDefined() || cache.get("indexing-properties").isDefined()) {
            writer.writeStartElement(Element.INDEXING.getLocalName());
            CacheResourceDefinition.INDEXING.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            CacheResourceDefinition.INDEXING_PROPERTIES.marshallAsElement(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined(StateTransferResourceDefinition.PATH.getKey())) {
            ModelNode stateTransfer = cache.get(StateTransferResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
            StateTransferResourceDefinition.ENABLED.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
            StateTransferResourceDefinition.TIMEOUT.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
            StateTransferResourceDefinition.CHUNK_SIZE.marshallAsAttribute(stateTransfer, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            writer.writeStartElement(Element.BACKUPS.getLocalName());
            for (Property property : cache.get(BackupSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(Element.BACKUP.getLocalName());
                writer.writeAttribute(Attribute.SITE.getLocalName(), property.getName());
                ModelNode backup = property.getValue();
                BackupSiteResourceDefinition.FAILURE_POLICY.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteResourceDefinition.STRATEGY.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteResourceDefinition.REPLICATION_TIMEOUT.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                BackupSiteResourceDefinition.ENABLED.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                if (backup.hasDefined("after-failures") || backup.hasDefined("min-wait")) {
                    writer.writeStartElement(Element.TAKE_OFFLINE.getLocalName());
                    BackupSiteResourceDefinition.TAKE_OFFLINE_AFTER_FAILURES.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                    BackupSiteResourceDefinition.TAKE_OFFLINE_MIN_WAIT.marshallAsAttribute(backup, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (cache.hasDefined(BackupForResourceDefinition.PATH.getKey())) {
            ModelNode backupFor = cache.get(BackupForResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.BACKUP_FOR.getLocalName());
            BackupForResourceDefinition.REMOTE_CACHE.marshallAsAttribute(backupFor, (XMLStreamWriter)writer);
            BackupForResourceDefinition.REMOTE_SITE.marshallAsAttribute(backupFor, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private static void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, ModelNode store, String key) throws XMLStreamException {
        if (store.hasDefined(key)) {
            ModelNode table = store.get(key);
            writer.writeStartElement(element.getLocalName());
            JDBCStoreResourceDefinition.PREFIX.marshallAsAttribute(table, (XMLStreamWriter)writer);
            JDBCStoreResourceDefinition.BATCH_SIZE.marshallAsAttribute(table, (XMLStreamWriter)writer);
            JDBCStoreResourceDefinition.FETCH_SIZE.marshallAsAttribute(table, (XMLStreamWriter)writer);
            InfinispanSubsystemXMLWriter.writeJDBCStoreColumn(writer, Element.ID_COLUMN, table, "id-column");
            InfinispanSubsystemXMLWriter.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, table, "data-column");
            InfinispanSubsystemXMLWriter.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, table, "timestamp-column");
            writer.writeEndElement();
        }
    }

    private static void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, ModelNode table, String key) throws XMLStreamException {
        if (table.hasDefined(key)) {
            ModelNode column = table.get(key);
            writer.writeStartElement(element.getLocalName());
            JDBCStoreResourceDefinition.COLUMN_NAME.marshallAsAttribute(column, (XMLStreamWriter)writer);
            JDBCStoreResourceDefinition.COLUMN_TYPE.marshallAsAttribute(column, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private static void writeStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        StoreResourceDefinition.SHARED.marshallAsAttribute(store, (XMLStreamWriter)writer);
        StoreResourceDefinition.PRELOAD.marshallAsAttribute(store, (XMLStreamWriter)writer);
        StoreResourceDefinition.PASSIVATION.marshallAsAttribute(store, (XMLStreamWriter)writer);
        StoreResourceDefinition.FETCH_STATE.marshallAsAttribute(store, (XMLStreamWriter)writer);
        StoreResourceDefinition.PURGE.marshallAsAttribute(store, (XMLStreamWriter)writer);
        StoreResourceDefinition.SINGLETON.marshallAsAttribute(store, (XMLStreamWriter)writer);
    }

    private static void writeJDBCStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        InfinispanSubsystemXMLWriter.writeStoreAttributes(writer, store);
        JDBCStoreResourceDefinition.DATA_SOURCE.marshallAsAttribute(store, (XMLStreamWriter)writer);
        JDBCStoreResourceDefinition.DIALECT.marshallAsAttribute(store, (XMLStreamWriter)writer);
    }

    private static void writeStoreElements(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.hasDefined(StoreWriteBehindResourceDefinition.PATH.getKey())) {
            ModelNode writeBehind = store.get(StoreWriteBehindResourceDefinition.PATH.getKeyValuePair());
            writer.writeStartElement(Element.WRITE_BEHIND.getLocalName());
            StoreWriteBehindResourceDefinition.FLUSH_LOCK_TIMEOUT.marshallAsAttribute(writeBehind, (XMLStreamWriter)writer);
            StoreWriteBehindResourceDefinition.MODIFICATION_QUEUE_SIZE.marshallAsAttribute(writeBehind, (XMLStreamWriter)writer);
            StoreWriteBehindResourceDefinition.SHUTDOWN_TIMEOUT.marshallAsAttribute(writeBehind, (XMLStreamWriter)writer);
            StoreWriteBehindResourceDefinition.THREAD_POOL_SIZE.marshallAsAttribute(writeBehind, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (store.hasDefined(StorePropertyResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : store.get(StorePropertyResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }
}

