/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreType;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JDBCStoreResourceDefinition
extends StoreResourceDefinition {
    static final SimpleAttributeDefinition DATA_SOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("datasource", ModelType.STRING, false).setXmlName(Attribute.DATASOURCE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition DIALECT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("dialect", ModelType.STRING, true).setXmlName(Attribute.DIALECT.getLocalName())).setValidator((ParameterValidator)new EnumValidator(DatabaseType.class, true, true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{DATA_SOURCE, DIALECT};
    static final SimpleAttributeDefinition BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("batch-size", ModelType.INT, true).setXmlName(Attribute.BATCH_SIZE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(100))).build();
    static final SimpleAttributeDefinition FETCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("fetch-size", ModelType.INT, true).setXmlName(Attribute.FETCH_SIZE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set(100))).build();
    static final SimpleAttributeDefinition PREFIX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("prefix", ModelType.STRING, true).setXmlName(Attribute.PREFIX.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    static final SimpleAttributeDefinition COLUMN_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName("name")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set("name"))).build();
    static final SimpleAttributeDefinition COLUMN_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setXmlName("type")).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setDefaultValue(new ModelNode().set("type"))).build();
    static final AttributeDefinition[] COLUMN_ATTRIBUTES = new AttributeDefinition[]{COLUMN_NAME, COLUMN_TYPE};
    static final ObjectTypeAttributeDefinition ID_COLUMN = ObjectTypeAttributeDefinition.Builder.of((String)"id-column", (AttributeDefinition[])COLUMN_ATTRIBUTES).setAllowNull(true).setSuffix("column").build();
    static final ObjectTypeAttributeDefinition DATA_COLUMN = ObjectTypeAttributeDefinition.Builder.of((String)"data-column", (AttributeDefinition[])COLUMN_ATTRIBUTES).setAllowNull(true).setSuffix("column").build();
    static final ObjectTypeAttributeDefinition TIMESTAMP_COLUMN = ObjectTypeAttributeDefinition.Builder.of((String)"timestamp-column", (AttributeDefinition[])COLUMN_ATTRIBUTES).setAllowNull(true).setSuffix("column").build();
    static final AttributeDefinition[] TABLE_ATTRIBUTES = new AttributeDefinition[]{PREFIX, BATCH_SIZE, FETCH_SIZE, ID_COLUMN, DATA_COLUMN, TIMESTAMP_COLUMN};
    @Deprecated
    static final ObjectTypeAttributeDefinition ENTRY_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"entry-table", (AttributeDefinition[])TABLE_ATTRIBUTES).setAllowNull(true).setSuffix("table").build();
    @Deprecated
    static final ObjectTypeAttributeDefinition BUCKET_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"bucket-table", (AttributeDefinition[])TABLE_ATTRIBUTES).setAllowNull(true).setSuffix("table").build();
    static final ObjectTypeAttributeDefinition STRING_KEYED_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"string-keyed-table", (AttributeDefinition[])TABLE_ATTRIBUTES).setAllowNull(true).setSuffix("table").build();
    static final ObjectTypeAttributeDefinition BINARY_KEYED_TABLE = ObjectTypeAttributeDefinition.Builder.of((String)"binary-keyed-table", (AttributeDefinition[])TABLE_ATTRIBUTES).setAllowNull(true).setSuffix("table").build();

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        if (InfinispanModel.VERSION_2_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{DIALECT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{DIALECT});
        }
        if (InfinispanModel.VERSION_1_4_0.requiresTransformation(version)) {
            HashMap<String, RejectAttributeChecker> columnCheckers = new HashMap<String, RejectAttributeChecker>();
            columnCheckers.put(COLUMN_NAME.getName(), RejectAttributeChecker.SIMPLE_EXPRESSIONS);
            columnCheckers.put(COLUMN_TYPE.getName(), RejectAttributeChecker.SIMPLE_EXPRESSIONS);
            RejectAttributeChecker.ObjectFieldsRejectAttributeChecker columnChecker = new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(columnCheckers);
            HashMap<String, Object> tableCheckers = new HashMap<String, Object>();
            tableCheckers.put(PREFIX.getName(), RejectAttributeChecker.SIMPLE_EXPRESSIONS);
            tableCheckers.put(BATCH_SIZE.getName(), RejectAttributeChecker.SIMPLE_EXPRESSIONS);
            tableCheckers.put(FETCH_SIZE.getName(), RejectAttributeChecker.SIMPLE_EXPRESSIONS);
            tableCheckers.put(ID_COLUMN.getName(), columnChecker);
            tableCheckers.put(DATA_COLUMN.getName(), columnChecker);
            tableCheckers.put(TIMESTAMP_COLUMN.getName(), columnChecker);
            RejectAttributeChecker.ObjectFieldsRejectAttributeChecker tableChecker = new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(tableCheckers);
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)tableChecker, new AttributeDefinition[]{BINARY_KEYED_TABLE, STRING_KEYED_TABLE})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{DATA_SOURCE});
        }
        StoreResourceDefinition.buildTransformation(version, builder);
    }

    JDBCStoreResourceDefinition(StoreType store, boolean allowRuntimeOnlyRegistration) {
        super(store, allowRuntimeOnlyRegistration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            registration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }
}

