/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.util.concurrent.locks.LockManagerImpl;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum LockingMetric implements Metric<LockManagerImpl>
{
    CURRENT_CONCURRENCY_LEVEL("current-concurrency-level", ModelType.INT){

        public ModelNode getValue(LockManagerImpl manager) {
            return new ModelNode(manager.getConcurrencyLevel());
        }
    }
    ,
    NUMBER_OF_LOCKS_AVAILABLE("number-of-locks-available", ModelType.INT){

        public ModelNode getValue(LockManagerImpl manager) {
            return new ModelNode(manager.getNumberOfLocksAvailable());
        }
    }
    ,
    NUMBER_OF_LOCKS_HELD("number-of-locks-held", ModelType.INT){

        public ModelNode getValue(LockManagerImpl manager) {
            return new ModelNode(manager.getNumberOfLocksHeld());
        }
    };

    private final AttributeDefinition definition;
    private static final Map<String, LockingMetric> metrics;

    private LockingMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static LockingMetric forName(String name) {
        return metrics.get(name);
    }

    static {
        metrics = new HashMap<String, LockingMetric>();
        for (LockingMetric metric : LockingMetric.values()) {
            metrics.put(metric.definition.getName(), metric);
        }
    }
}

