/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.interceptors.ActivationInterceptor;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum StoreMetric implements Metric<ActivationInterceptor>
{
    CACHE_LOADER_LOADS("cache-loader-loads", ModelType.LONG){

        public ModelNode getValue(ActivationInterceptor interceptor) {
            return new ModelNode(interceptor.getCacheLoaderLoads());
        }
    }
    ,
    CACHE_LOADER_MISSES("cache-loader-misses", ModelType.LONG){

        public ModelNode getValue(ActivationInterceptor interceptor) {
            return new ModelNode(interceptor.getCacheLoaderMisses());
        }
    };

    private final AttributeDefinition definition;
    private static final Map<String, StoreMetric> metrics;

    private StoreMetric(String name, ModelType type) {
        this.definition = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type, true).setStorageRuntime()).build();
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static StoreMetric forName(String name) {
        return metrics.get(name);
    }

    static {
        metrics = new HashMap<String, StoreMetric>();
        for (StoreMetric metric : StoreMetric.values()) {
            metrics.put(metric.definition.getName(), metric);
        }
    }
}

