/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.interceptors.ActivationInterceptor;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheMetric;
import org.jboss.as.clustering.infinispan.subsystem.StoreMetric;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;

public class StoreMetricsHandler
extends AbstractRuntimeOnlyHandler {
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String containerName = address.getElement(address.size() - 3).getValue();
        String cacheName = address.getElement(address.size() - 2).getValue();
        String name = Operations.getAttributeName((ModelNode)operation);
        StoreMetric metric = StoreMetric.forName(name);
        if (metric == null) {
            context.getFailureDescription().set(InfinispanLogger.ROOT_LOGGER.unknownMetric(name));
        } else {
            Cache cache = (Cache)ServiceContainerHelper.findValue((ServiceRegistry)context.getServiceRegistry(false), (ServiceName)CacheServiceName.CACHE.getServiceName(containerName, cacheName));
            if (cache != null) {
                ActivationInterceptor interceptor = CacheMetric.findInterceptor(cache, ActivationInterceptor.class);
                context.getResult().set(interceptor != null ? metric.getValue(interceptor) : new ModelNode(0));
            }
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

