/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ServiceLoader;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceRegistrationHandler;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelConnectorBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.ClusteredGroupBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;

public class ChannelAddHandler
extends AbstractAddStepHandler {
    private final boolean allowRuntimeOnlyRegistration;

    ChannelAddHandler(boolean allowRuntimeOnlyRegistration) {
        super(ChannelResourceDefinition.ATTRIBUTES);
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        if (this.allowRuntimeOnlyRegistration && context.getRunningMode() == RunningMode.NORMAL) {
            String name = context.getCurrentAddressValue();
            String stack = ModelNodes.asString((ModelNode)ChannelResourceDefinition.STACK.resolveModelAttribute(context, resource.getModel()));
            PathAddress address = context.getCurrentAddress();
            PathAddress subsystemAddress = address.subAddress(0, address.size() - 1);
            PathAddress stackAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement(stack != null ? stack : JGroupsSubsystemResourceDefinition.DEFAULT_STACK.resolveModelAttribute(context, context.readResourceFromRoot(subsystemAddress, false).getModel()).asString())});
            context.addStep((OperationStepHandler)new ProtocolResourceRegistrationHandler(name, stackAddress), OperationContext.Stage.MODEL);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ChannelAddHandler.installRuntimeServices(context, operation, model);
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        String stack = ModelNodes.asString((ModelNode)ChannelResourceDefinition.STACK.resolveModelAttribute(context, model), (String)"default-stack");
        ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)ChannelResourceDefinition.MODULE.resolveModelAttribute(context, model));
        ServiceTarget target = context.getServiceTarget();
        new AliasServiceBuilder(ChannelServiceName.FACTORY.getServiceName(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(stack), ChannelFactory.class).build(target).install();
        new ChannelBuilder(name).build(target).install();
        new ChannelConnectorBuilder(name).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding(name), ChannelServiceName.CHANNEL.getServiceName(name), Channel.class).build(target).install();
        new ForkChannelFactoryBuilder(name).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelFactoryBinding(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(name), ChannelFactory.class).build(target).install();
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(ClusteredGroupBuilderProvider.class, ClusteredGroupBuilderProvider.class.getClassLoader())) {
            for (Builder builder : groupBuilderProvider.getBuilders(name, module)) {
                JGroupsLogger.ROOT_LOGGER.debugf("Installing %s for channel %s", builder.getServiceName(), name);
                builder.build(target).install();
            }
        }
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) {
        String name = context.getCurrentAddressValue();
        context.removeService(JGroupsBindingFactory.createChannelBinding(name).getBinderServiceName());
        for (ChannelServiceName factory : ChannelServiceName.values()) {
            context.removeService(factory.getServiceName(name));
        }
        context.removeService(JGroupsBindingFactory.createChannelFactoryBinding(name).getBinderServiceName());
        context.removeService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(name));
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(ClusteredGroupBuilderProvider.class, ClusteredGroupBuilderProvider.class.getClassLoader())) {
            for (Builder builder : groupBuilderProvider.getBuilders(name, null)) {
                JGroupsLogger.ROOT_LOGGER.debugf("Removing %s for channel %s", builder.getServiceName(), name);
                context.removeService(builder.getServiceName());
            }
        }
    }
}

