/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.network.SocketBinding;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class TransportConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<TransportConfiguration>
implements TransportConfiguration {
    private ValueDependency<SocketBinding> diagnosticsSocketBinding;
    private boolean shared = TransportResourceDefinition.SHARED.getDefaultValue().asBoolean();
    private TransportConfiguration.Topology topology = null;

    public TransportConfigurationBuilder(String stackName, String name) {
        super(stackName, name);
    }

    @Override
    public ServiceBuilder<TransportConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        if (this.diagnosticsSocketBinding != null) {
            this.diagnosticsSocketBinding.register(builder);
        }
        return builder;
    }

    public TransportConfiguration getValue() {
        return this;
    }

    public TransportConfigurationBuilder setModule(ModuleIdentifier module) {
        super.setModule(module);
        return this;
    }

    public TransportConfigurationBuilder setSocketBinding(String socketBindingName) {
        super.setSocketBinding(socketBindingName);
        return this;
    }

    public TransportConfigurationBuilder addProperty(String name, String value) {
        super.addProperty(name, value);
        return this;
    }

    public TransportConfigurationBuilder setDiagnosticsSocket(String socketBindingName) {
        if (socketBindingName != null) {
            this.diagnosticsSocketBinding = new InjectedValueDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBindingName}), SocketBinding.class);
        }
        return this;
    }

    public TransportConfigurationBuilder setShared(boolean shared) {
        this.shared = shared;
        return this;
    }

    public TransportConfigurationBuilder setTopology(final String site, final String rack, final String machine) {
        if (site != null || rack != null || machine != null) {
            this.topology = new TransportConfiguration.Topology(){

                public String getMachine() {
                    return machine;
                }

                public String getRack() {
                    return rack;
                }

                public String getSite() {
                    return site;
                }
            };
        }
        return this;
    }

    public boolean isShared() {
        return this.shared;
    }

    public SocketBinding getDiagnosticsSocketBinding() {
        return this.diagnosticsSocketBinding != null ? (SocketBinding)this.diagnosticsSocketBinding.getValue() : null;
    }

    public TransportConfiguration.Topology getTopology() {
        return this.topology;
    }
}

