/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.jms.Queue;
import org.hornetq.jms.client.HornetQQueue;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.as.server.Services;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class JMSQueueService
implements Service<Queue> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final String queueName;
    private final String selectorString;
    private final boolean durable;
    private final String[] jndi;
    private Queue queue;

    public JMSQueueService(String queueName, String selectorString, boolean durable, String[] jndi) {
        this.queueName = queueName;
        this.selectorString = selectorString;
        this.durable = durable;
        this.jndi = jndi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createQueue(false, JMSQueueService.this.queueName, JMSQueueService.this.selectorString, JMSQueueService.this.durable, JMSQueueService.this.jndi);
                    JMSQueueService.this.queue = (Queue)new HornetQQueue(JMSQueueService.this.queueName);
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "queue"));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.removeQueueFromJNDI(JMSQueueService.this.queueName);
                    JMSQueueService.this.queue = null;
                }
                catch (Throwable e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy(e, "queue", JMSQueueService.this.queueName);
                }
                context.complete();
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public Queue getValue() throws IllegalStateException, IllegalArgumentException {
        return this.queue;
    }

    public static Service<Queue> installService(String name, ServiceTarget serviceTarget, ServiceName hqServiceName, String selector, boolean durable, String[] jndiBindings) {
        JMSQueueService service = new JMSQueueService(name, selector, durable, jndiBindings);
        ServiceName serviceName = JMSServices.getJmsQueueBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(HornetQActivationService.getHornetQActivationServiceName(hqServiceName)).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.jmsServer).setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.executorInjector, (boolean)false);
        serviceBuilder.install();
        return service;
    }
}

