/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.regex.Pattern;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.logging.Log;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.util.logging.LogFactory;

public final class LuceneKey2StringMapper
implements TwoWayKey2StringMapper {
    static final Pattern singlePipePattern = Pattern.compile("\\|");
    private static final Log log = (Log)LogFactory.getLog(LuceneKey2StringMapper.class, Log.class);

    public boolean isSupportedType(Class<?> keyType) {
        return keyType == ChunkCacheKey.class || keyType == FileCacheKey.class || keyType == FileListCacheKey.class || keyType == FileReadLockKey.class;
    }

    public String getStringMapping(Object key) {
        return key.toString();
    }

    public Object getKeyMapping(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Not supporting null keys");
        }
        if (key.startsWith("*|")) {
            return new FileListCacheKey(key.substring(2));
        }
        String[] split = singlePipePattern.split(key);
        if (split.length != 3 && split.length != 4) {
            throw log.keyMappperUnexpectedStringFormat(key);
        }
        switch (split[1]) {
            case "M": {
                if (split.length != 3) {
                    throw log.keyMappperUnexpectedStringFormat(key);
                }
                return new FileCacheKey(split[2], split[0]);
            }
            case "RL": {
                if (split.length != 3) {
                    throw log.keyMappperUnexpectedStringFormat(key);
                }
                return new FileReadLockKey(split[2], split[0]);
            }
        }
        if (split.length != 4) {
            throw log.keyMappperUnexpectedStringFormat(key);
        }
        try {
            int chunkId = Integer.parseInt(split[1]);
            int bufferSize = Integer.parseInt(split[2]);
            return new ChunkCacheKey(split[3], split[0], chunkId, bufferSize);
        }
        catch (NumberFormatException nfe) {
            throw log.keyMappperUnexpectedStringFormat(key);
        }
    }
}

