/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class SessionObjectReferenceImpl
implements SessionObjectReference {
    private final Map<String, ServiceName> viewServices;
    private final String ejbName;
    private volatile transient Map<String, ManagedReference> businessInterfaceToReference;

    public SessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.ejbName = descriptor.getEjbName();
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (Map.Entry<Class<?>, ServiceName> entry : descriptor.getViewServices().entrySet()) {
            Class<?> viewClass = entry.getKey();
            if (viewClass == null) continue;
            HashSet<Class> seen = new HashSet<Class>();
            HashSet toProcess = new HashSet();
            toProcess.add(viewClass);
            while (!toProcess.isEmpty()) {
                Iterator it = toProcess.iterator();
                Class clazz = (Class)it.next();
                it.remove();
                seen.add(clazz);
                viewServices.put(clazz.getName(), entry.getValue());
                Class superclass = clazz.getSuperclass();
                if (superclass != Object.class && superclass != null && !seen.contains(superclass)) {
                    toProcess.add(superclass);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (seen.contains(iface)) continue;
                    toProcess.add(iface);
                }
            }
        }
        this.viewServices = viewServices;
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        String businessInterfaceName = businessInterfaceType.getName();
        ManagedReference managedReference = null;
        if (this.businessInterfaceToReference == null) {
            this.businessInterfaceToReference = new HashMap<String, ManagedReference>();
        } else {
            managedReference = this.businessInterfaceToReference.get(businessInterfaceName);
        }
        if (managedReference == null) {
            if (this.viewServices.containsKey(businessInterfaceType.getName())) {
                ServiceController serviceController = SessionObjectReferenceImpl.currentServiceContainer().getRequiredService(this.viewServices.get(businessInterfaceType.getName()));
                ComponentView view = (ComponentView)serviceController.getValue();
                try {
                    managedReference = view.createInstance();
                    this.businessInterfaceToReference.put(businessInterfaceType.getName(), managedReference);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw WeldLogger.ROOT_LOGGER.viewNotFoundOnEJB(businessInterfaceType.getName(), this.ejbName);
            }
        }
        return (S)managedReference.getInstance();
    }

    public void remove() {
    }

    public boolean isRemoved() {
        return false;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }
}

