/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.request.Renewing;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.SymmetricKeyHandler;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.provider.TokenReference;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.derivedKey.ConversationConstants;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.w3c.dom.Document;

public class SCTProvider
implements TokenProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(SCTProvider.class);
    private boolean returnEntropy = true;
    private long lifetime = 1800L;

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public boolean canHandleToken(String tokenType) {
        return this.canHandleToken(tokenType, null);
    }

    @Override
    public boolean canHandleToken(String tokenType, String realm) {
        return "http://schemas.xmlsoap.org/ws/2005/02/sc/sct".equals(tokenType) || "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(tokenType);
    }

    public void setReturnEntropy(boolean returnEntropy) {
        this.returnEntropy = returnEntropy;
    }

    public boolean isReturnEntropy() {
        return this.returnEntropy;
    }

    @Override
    public TokenProviderResponse createToken(TokenProviderParameters tokenParameters) {
        TokenRequirements tokenRequirements = tokenParameters.getTokenRequirements();
        LOG.fine("Handling token of type: " + tokenRequirements.getTokenType());
        if (tokenParameters.getTokenStore() == null) {
            LOG.log(Level.FINE, "A cache must be configured to use the SCTProvider");
            throw new STSException("Can't serialize SCT", STSException.REQUEST_FAILED);
        }
        SymmetricKeyHandler keyHandler = new SymmetricKeyHandler(tokenParameters);
        keyHandler.createSymmetricKey();
        try {
            Renewing renewing;
            Document doc = DOMUtils.createDocument();
            SecurityContextToken sct = new SecurityContextToken(SCTProvider.getWSCVersion(tokenRequirements.getTokenType()), doc);
            TokenProviderResponse response = new TokenProviderResponse();
            response.setToken(sct.getElement());
            response.setTokenId(sct.getIdentifier());
            if (this.returnEntropy) {
                response.setEntropy(keyHandler.getEntropyBytes());
            }
            long keySize = keyHandler.getKeySize();
            response.setKeySize(keySize);
            response.setComputedKey(keyHandler.isComputedKey());
            Date currentDate = new Date();
            response.setCreated(currentDate);
            Date expires = null;
            if (this.lifetime > 0L) {
                expires = new Date();
                long currentTime = currentDate.getTime();
                expires.setTime(currentTime + this.lifetime * 1000L);
            }
            response.setExpires(expires);
            SecurityToken token = new SecurityToken(sct.getIdentifier(), currentDate, expires);
            token.setSecret(keyHandler.getSecret());
            token.setPrincipal(tokenParameters.getPrincipal());
            Properties props = token.getProperties();
            if (props == null) {
                props = new Properties();
            }
            token.setProperties(props);
            if (tokenParameters.getRealm() != null) {
                props.setProperty("org.apache.cxf.sts.token.realm", tokenParameters.getRealm());
            }
            if ((renewing = tokenParameters.getTokenRequirements().getRenewing()) != null) {
                props.put("org.apache.cxf.sts.token.renewing.allow", String.valueOf(renewing.isAllowRenewing()));
                props.put("org.apache.cxf.sts.token.renewing.allow.after.expiry", String.valueOf(renewing.isAllowRenewingAfterExpiry()));
            } else {
                props.setProperty("org.apache.cxf.sts.token.renewing.allow", "true");
                props.setProperty("org.apache.cxf.sts.token.renewing.allow.after.expiry", "false");
            }
            tokenParameters.getTokenStore().add(token);
            TokenReference attachedReference = new TokenReference();
            attachedReference.setIdentifier(sct.getID());
            attachedReference.setUseDirectReference(true);
            attachedReference.setWsseValueType(tokenRequirements.getTokenType());
            response.setAttachedReference(attachedReference);
            TokenReference unAttachedReference = new TokenReference();
            unAttachedReference.setIdentifier(sct.getIdentifier());
            unAttachedReference.setUseDirectReference(true);
            unAttachedReference.setWsseValueType(tokenRequirements.getTokenType());
            response.setUnattachedReference(unAttachedReference);
            return response;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "", e);
            throw new STSException("Can't serialize SCT", (Throwable)e, STSException.REQUEST_FAILED);
        }
    }

    private static int getWSCVersion(String tokenType) throws WSSecurityException {
        if (tokenType == null) {
            return 2;
        }
        if (tokenType.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            return ConversationConstants.getWSTVersion((String)"http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        if (tokenType.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            return ConversationConstants.getWSTVersion((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unsupportedSecConvVersion", new Object[0]);
    }
}

