/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.Proposal;
import org.hornetq.core.server.group.impl.Response;

public final class BindingsImpl
implements Bindings {
    public static final int MAX_GROUP_RETRY = 10;
    private static boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final ConcurrentMap<SimpleString, List<Binding>> routingNameBindingMap = new ConcurrentHashMap<SimpleString, List<Binding>>();
    private final Map<SimpleString, Integer> routingNamePositions = new ConcurrentHashMap<SimpleString, Integer>();
    private final Map<Long, Binding> bindingsMap = new ConcurrentHashMap<Long, Binding>();
    private final List<Binding> exclusiveBindings = new CopyOnWriteArrayList<Binding>();
    private volatile boolean routeWhenNoConsumers;
    private final GroupingHandler groupingHandler;
    private final PagingStore pageStore;
    private final SimpleString name;

    public BindingsImpl(SimpleString name, GroupingHandler groupingHandler, PagingStore pageStore) {
        this.groupingHandler = groupingHandler;
        this.pageStore = pageStore;
        this.name = name;
    }

    @Override
    public void setRouteWhenNoConsumers(boolean routeWhenNoConsumers) {
        this.routeWhenNoConsumers = routeWhenNoConsumers;
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.bindingsMap.values();
    }

    @Override
    public void unproposed(SimpleString groupID) {
        for (Binding binding : this.bindingsMap.values()) {
            binding.unproposed(groupID);
        }
    }

    @Override
    public void addBinding(Binding binding) {
        if (isTrace) {
            HornetQServerLogger.LOGGER.trace("addBinding(" + binding + ") being called");
        }
        if (binding.isExclusive()) {
            this.exclusiveBindings.add(binding);
        } else {
            List oldBindings;
            SimpleString routingName = binding.getRoutingName();
            List<Binding> bindings = (CopyOnWriteArrayList<Binding>)this.routingNameBindingMap.get(routingName);
            if (bindings == null && (oldBindings = (List)this.routingNameBindingMap.putIfAbsent(routingName, bindings = new CopyOnWriteArrayList<Binding>())) != null) {
                bindings = oldBindings;
            }
            bindings.add(binding);
        }
        this.bindingsMap.put(binding.getID(), binding);
        if (isTrace) {
            HornetQServerLogger.LOGGER.trace("Adding binding " + binding + " into " + this + " bindingTable: " + this.debugBindings());
        }
    }

    @Override
    public void removeBinding(Binding binding) {
        if (binding.isExclusive()) {
            this.exclusiveBindings.remove(binding);
        } else {
            SimpleString routingName = binding.getRoutingName();
            List bindings = (List)this.routingNameBindingMap.get(routingName);
            if (bindings != null) {
                bindings.remove(binding);
                if (bindings.isEmpty()) {
                    this.routingNameBindingMap.remove(routingName);
                }
            }
        }
        this.bindingsMap.remove(binding.getID());
        if (isTrace) {
            HornetQServerLogger.LOGGER.trace("Removing binding " + binding + " into " + this + " bindingTable: " + this.debugBindings());
        }
    }

    @Override
    public boolean redistribute(ServerMessage message, Queue originatingQueue, RoutingContext context) throws Exception {
        SimpleString routingName;
        List bindings;
        if (this.routeWhenNoConsumers) {
            return false;
        }
        if (isTrace) {
            HornetQServerLogger.LOGGER.trace("Redistributing message " + message);
        }
        if ((bindings = (List)this.routingNameBindingMap.get(routingName = originatingQueue.getName())) == null) {
            return false;
        }
        Integer ipos = this.routingNamePositions.get(routingName);
        int pos = ipos != null ? ipos : 0;
        int length = bindings.size();
        int startPos = pos;
        Binding theBinding = null;
        while (true) {
            Binding binding;
            try {
                binding = (Binding)bindings.get(pos);
            }
            catch (IndexOutOfBoundsException e) {
                if (!bindings.isEmpty()) {
                    pos = 0;
                    startPos = 0;
                    length = bindings.size();
                    continue;
                }
                break;
            }
            pos = this.incrementPos(pos, length);
            Filter filter = binding.getFilter();
            boolean highPrior = binding.isHighAcceptPriority(message);
            if (highPrior && binding.getBindable() != originatingQueue && (filter == null || filter.match(message))) {
                theBinding = binding;
                break;
            }
            if (pos == startPos) break;
        }
        this.routingNamePositions.put(routingName, pos);
        if (theBinding != null) {
            theBinding.route(message, context);
            return true;
        }
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        this.route(message, context, true);
    }

    private void route(ServerMessage message, RoutingContext context, boolean groupRouting) throws Exception {
        boolean routed = false;
        if (!this.exclusiveBindings.isEmpty()) {
            for (Binding binding : this.exclusiveBindings) {
                if (binding.getFilter() != null && !binding.getFilter().match(message)) continue;
                binding.getBindable().route(message, context);
                routed = true;
            }
        }
        if (!routed) {
            if (message.containsProperty(MessageImpl.HDR_ROUTE_TO_IDS)) {
                this.routeFromCluster(message, context);
            } else if (this.groupingHandler != null && groupRouting && message.containsProperty(Message.HDR_GROUP_ID)) {
                this.routeUsingStrictOrdering(message, context, this.groupingHandler, 0);
            } else {
                if (isTrace) {
                    HornetQServerLogger.LOGGER.trace("Routing message " + message + " on binding=" + this);
                }
                for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
                    Binding theBinding;
                    SimpleString routingName = (SimpleString)entry.getKey();
                    List bindings = (List)entry.getValue();
                    if (bindings == null || (theBinding = this.getNextBinding(message, routingName, bindings)) == null) continue;
                    theBinding.route(message, context);
                }
            }
        }
    }

    public String toString() {
        return "BindingsImpl [name=" + this.name + "]";
    }

    private Binding getNextBinding(ServerMessage message, SimpleString routingName, List<Binding> bindings) {
        Binding theBinding;
        int startPos;
        int pos;
        block11: {
            Integer ipos = this.routingNamePositions.get(routingName);
            pos = ipos != null ? ipos : 0;
            int length = bindings.size();
            startPos = pos;
            theBinding = null;
            int lastLowPriorityBinding = -1;
            while (true) {
                Binding binding;
                try {
                    binding = bindings.get(pos);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!bindings.isEmpty()) {
                        pos = 0;
                        startPos = 0;
                        length = bindings.size();
                        continue;
                    }
                    break block11;
                }
                Filter filter = binding.getFilter();
                if (filter == null || filter.match(message)) {
                    if (length == 1 || this.routeWhenNoConsumers || binding.isHighAcceptPriority(message)) {
                        theBinding = binding;
                        pos = this.incrementPos(pos, length);
                        break block11;
                    }
                    if (lastLowPriorityBinding == -1 || !this.routeWhenNoConsumers && binding instanceof LocalQueueBinding) {
                        lastLowPriorityBinding = pos;
                    }
                }
                if ((pos = this.incrementPos(pos, length)) != startPos) continue;
                if (lastLowPriorityBinding == -1) break block11;
                try {
                    theBinding = bindings.get(lastLowPriorityBinding);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!bindings.isEmpty()) {
                        pos = 0;
                        lastLowPriorityBinding = -1;
                        continue;
                    }
                    break block11;
                }
                break;
            }
            pos = this.incrementPos(lastLowPriorityBinding, length);
        }
        if (pos != startPos) {
            this.routingNamePositions.put(routingName, pos);
        }
        return theBinding;
    }

    private void routeUsingStrictOrdering(ServerMessage message, RoutingContext context, GroupingHandler groupingGroupingHandler, int tries) throws Exception {
        SimpleString groupId = message.getSimpleStringProperty(Message.HDR_GROUP_ID);
        for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
            SimpleString routingName = (SimpleString)entry.getKey();
            List bindings = (List)entry.getValue();
            if (bindings == null) continue;
            SimpleString fullID = groupId.concat(".").concat(routingName);
            Response resp = groupingGroupingHandler.getProposal(fullID, true);
            if (resp == null) {
                Binding theBinding = this.getNextBinding(message, routingName, bindings);
                if (theBinding == null) continue;
                resp = groupingGroupingHandler.propose(new Proposal(fullID, theBinding.getClusterName()));
                if (resp == null) {
                    HornetQServerLogger.LOGGER.debug("it got a timeout on propose, trying again, number of retries: " + tries);
                    theBinding = null;
                }
                if (resp != null && resp.getAlternativeClusterName() != null) {
                    theBinding = this.locateBinding(resp.getAlternativeClusterName(), bindings);
                }
                this.routeAndCheckNull(message, context, resp, theBinding, groupId, tries);
                continue;
            }
            Binding chosen = this.locateBinding(resp.getChosenClusterName(), bindings);
            this.routeAndCheckNull(message, context, resp, chosen, groupId, tries);
        }
    }

    private Binding locateBinding(SimpleString clusterName, List<Binding> bindings) {
        for (Binding binding : bindings) {
            if (!binding.getClusterName().equals((Object)clusterName)) continue;
            return binding;
        }
        return null;
    }

    private void routeAndCheckNull(ServerMessage message, RoutingContext context, Response resp, Binding theBinding, SimpleString groupId, int tries) throws Exception {
        if (theBinding != null) {
            theBinding.route(message, context);
        } else {
            if (resp != null) {
                this.groupingHandler.forceRemove(resp.getGroupId(), resp.getClusterName());
            }
            if (tries < 10) {
                this.routeUsingStrictOrdering(message, context, this.groupingHandler, tries + 1);
            } else {
                HornetQServerLogger.LOGGER.impossibleToRouteGrouped();
                this.route(message, context, false);
            }
        }
    }

    private String debugBindings() {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.println("\n***************************************");
        out.println("routingNameBindingMap:");
        if (this.routingNameBindingMap.isEmpty()) {
            out.println("EMPTY!");
        }
        for (Map.Entry entry : this.routingNameBindingMap.entrySet()) {
            out.print("key=" + entry.getKey() + ", value=" + entry.getValue());
            out.println();
        }
        out.println();
        out.println("RoutingNamePositions:");
        if (this.routingNamePositions.isEmpty()) {
            out.println("EMPTY!");
        }
        for (Map.Entry<Object, Object> entry : this.routingNamePositions.entrySet()) {
            out.println("key=" + entry.getKey() + ", value=" + entry.getValue());
        }
        out.println();
        out.println("BindingsMap:");
        if (this.bindingsMap.isEmpty()) {
            out.println("EMPTY!");
        }
        for (Map.Entry<Object, Object> entry : this.bindingsMap.entrySet()) {
            out.println("Key=" + entry.getKey() + ", value=" + entry.getValue());
        }
        out.println();
        out.println("ExclusiveBindings:");
        if (this.exclusiveBindings.isEmpty()) {
            out.println("EMPTY!");
        }
        for (Binding binding : this.exclusiveBindings) {
            out.println(binding);
        }
        out.println("#####################################################");
        return writer.toString();
    }

    private void routeFromCluster(ServerMessage message, RoutingContext context) throws Exception {
        byte[] ids = (byte[])message.removeProperty(MessageImpl.HDR_ROUTE_TO_IDS);
        ByteBuffer buff = ByteBuffer.wrap(ids);
        while (buff.hasRemaining()) {
            long bindingID = buff.getLong();
            Binding binding = this.bindingsMap.get(bindingID);
            if (binding != null) {
                binding.route(message, context);
                continue;
            }
            HornetQServerLogger.LOGGER.warn("Couldn't find binding with id=" + bindingID + " on routeFromCluster for message=" + message + " binding = " + this);
        }
    }

    private int incrementPos(int pos, int length) {
        if (++pos == length) {
            pos = 0;
        }
        return pos;
    }
}

