/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.conduits.ByteActivityCallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class BytesSentStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ByteActivityCallback callback;

    public BytesSentStreamSinkConduit(StreamSinkConduit next, ByteActivityCallback callback) {
        super(next);
        this.callback = callback;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        long l = super.transferFrom(src, position, count);
        this.callback.activity(l);
        return l;
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        long l = super.transferFrom(source, count, throughBuffer);
        this.callback.activity(l);
        return l;
    }

    public int write(ByteBuffer src) throws IOException {
        int i = super.write(src);
        this.callback.activity(i);
        return i;
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long l = super.write(srcs, offs, len);
        this.callback.activity(l);
        return l;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        int i = super.writeFinal(src);
        this.callback.activity(i);
        return i;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long l = super.writeFinal(srcs, offset, length);
        this.callback.activity(l);
        return l;
    }
}

