/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RenegotiationRequiredException;
import io.undertow.server.SSLSessionInfo;
import java.io.IOException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

class Http2SslSessionInfo
implements SSLSessionInfo {
    private final Http2Channel channel;

    public Http2SslSessionInfo(Http2Channel channel) {
        this.channel = channel;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = (SslClientAuthMode)this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        throw UndertowMessages.MESSAGES.renegotiationNotSupported();
    }
}

