/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.XMLElement;
import org.wildfly.extension.picketlink.federation.Namespace;
import org.wildfly.extension.picketlink.federation.model.FederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.AttributeManagerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.RoleGeneratorResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyStoreProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.saml.SAMLResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.sp.ServiceProviderResourceDefinition;

public abstract class AbstractFederationSubsystemReader
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        Namespace nameSpace = Namespace.forUri(reader.getNamespaceURI());
        ModelNode subsystemNode = this.createSubsystemRoot();
        addOperations.add(subsystemNode);
        switch (nameSpace) {
            case PICKETLINK_FEDERATION_1_0: {
                this.readElement(reader, subsystemNode, addOperations);
                break;
            }
            case PICKETLINK_FEDERATION_2_0: {
                this.readElement(reader, subsystemNode, addOperations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void readElement(XMLExtendedStreamReader reader, ModelNode subsystemNode, List<ModelNode> addOperations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 8) {
            if (!reader.isStartElement() || XMLElement.forName(reader.getLocalName()) != null) continue;
            ModelElement modelKey = ModelElement.forName(reader.getLocalName());
            if (modelKey == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (modelKey) {
                case FEDERATION: {
                    this.parseFederation(reader, subsystemNode, addOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFederation(XMLExtendedStreamReader reader, ModelNode subsystemNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode federationNode = this.parseConfig(reader, ModelElement.FEDERATION, ModelElement.COMMON_NAME.getName(), subsystemNode, Arrays.asList(FederationResourceDefinition.ATTRIBUTE_DEFINITIONS), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case KEY_STORE: {
                        AbstractFederationSubsystemReader.this.parseKeyStore(reader, parentNode, addOperations);
                        break;
                    }
                    case SAML: {
                        AbstractFederationSubsystemReader.this.parseConfig(reader, ModelElement.SAML, null, parentNode, SAMLResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case IDENTITY_PROVIDER: {
                        AbstractFederationSubsystemReader.this.parseIdentityProviderConfig(reader, parentNode, addOperations);
                        break;
                    }
                    case SERVICE_PROVIDER: {
                        AbstractFederationSubsystemReader.this.parseServiceProviderConfig(reader, parentNode, addOperations);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
            }
        }, ModelElement.FEDERATION, federationNode, reader, addOperations);
    }

    protected void parseKeyStore(XMLExtendedStreamReader reader, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityProviderNode = this.parseConfig(reader, ModelElement.KEY_STORE, null, parentNode, KeyStoreProviderResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }, ModelElement.KEY_STORE, identityProviderNode, reader, addOperations);
    }

    private void parseServiceProviderConfig(XMLExtendedStreamReader reader, ModelNode federationNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode serviceProviderNode = this.parseConfig(reader, ModelElement.SERVICE_PROVIDER, ModelElement.COMMON_NAME.getName(), federationNode, Arrays.asList(ServiceProviderResourceDefinition.ATTRIBUTE_DEFINITIONS), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case COMMON_HANDLER: {
                        AbstractFederationSubsystemReader.this.parseHandlerConfig(reader, parentNode, addOperations);
                    }
                }
            }
        }, ModelElement.SERVICE_PROVIDER, serviceProviderNode, reader, addOperations);
    }

    protected void parseHandlerConfig(XMLExtendedStreamReader reader, ModelNode entityProviderNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode handlerNode = this.parseConfig(reader, ModelElement.COMMON_HANDLER, ModelElement.COMMON_NAME.getName(), entityProviderNode, HandlerResourceDefinition.INSTANCE.getAttributes(), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case COMMON_HANDLER_PARAMETER: {
                        AbstractFederationSubsystemReader.this.parseConfig(reader, ModelElement.COMMON_HANDLER_PARAMETER, ModelElement.COMMON_NAME.getName(), parentNode, HandlerParameterResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
            }
        }, ModelElement.COMMON_HANDLER, handlerNode, reader, addOperations);
    }

    private void parseIdentityProviderConfig(XMLExtendedStreamReader reader, ModelNode federationNode, List<ModelNode> addOperations) throws XMLStreamException {
        ModelNode identityProviderNode = this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER, ModelElement.COMMON_NAME.getName(), federationNode, Arrays.asList(IdentityProviderResourceDefinition.ATTRIBUTE_DEFINITIONS), addOperations);
        this.parseElement(new ElementParser(){

            @Override
            public void parse(XMLExtendedStreamReader reader, ModelElement element, ModelNode parentNode, List<ModelNode> addOperations) throws XMLStreamException {
                switch (element) {
                    case IDENTITY_PROVIDER_TRUST_DOMAIN: {
                        AbstractFederationSubsystemReader.this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN, ModelElement.COMMON_NAME.getName(), parentNode, TrustDomainResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case IDENTITY_PROVIDER_ROLE_GENERATOR: {
                        AbstractFederationSubsystemReader.this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_ROLE_GENERATOR, ModelElement.COMMON_NAME.getName(), parentNode, RoleGeneratorResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case IDENTITY_PROVIDER_ATTRIBUTE_MANAGER: {
                        AbstractFederationSubsystemReader.this.parseConfig(reader, ModelElement.IDENTITY_PROVIDER_ATTRIBUTE_MANAGER, ModelElement.COMMON_NAME.getName(), parentNode, AttributeManagerResourceDefinition.INSTANCE.getAttributes(), addOperations);
                        break;
                    }
                    case COMMON_HANDLER: {
                        AbstractFederationSubsystemReader.this.parseHandlerConfig(reader, parentNode, addOperations);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
            }
        }, ModelElement.IDENTITY_PROVIDER, identityProviderNode, reader, addOperations);
    }

    private ModelNode createSubsystemRoot() {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "picketlink-federation");
        subsystemAddress.protect();
        return Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
    }

    protected ModelNode parseConfig(XMLExtendedStreamReader reader, ModelElement xmlElement, String key, ModelNode lastNode, List<SimpleAttributeDefinition> attributes, List<ModelNode> addOperations) throws XMLStreamException {
        if (!reader.getLocalName().equals(xmlElement.getName())) {
            return null;
        }
        ModelNode modelNode = Util.getEmptyOperation((String)"add", null);
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeLocalName = reader.getAttributeLocalName(i);
            if (ModelElement.forName(attributeLocalName) != null) continue;
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : attributes) {
            String attributeValue = reader.getAttributeValue("", simpleAttributeDefinition.getXmlName());
            simpleAttributeDefinition.parseAndSetParameter(attributeValue, modelNode, (XMLStreamReader)reader);
        }
        String name = xmlElement.getName();
        if (key != null) {
            name = key;
            if (modelNode.hasDefined(key)) {
                name = modelNode.get(key).asString();
            } else {
                String attributeValue = reader.getAttributeValue("", key);
                if (attributeValue != null) {
                    name = attributeValue;
                }
            }
        }
        modelNode.get("address").set(lastNode.clone().get("address").add(xmlElement.getName(), name));
        addOperations.add(modelNode);
        return modelNode;
    }

    protected void parseElement(ElementParser parser, ModelElement parentElement, ModelNode parentNode, XMLExtendedStreamReader reader, List<ModelNode> addOperations) throws XMLStreamException {
        HashSet<String> visited = new HashSet<String>();
        while (reader.hasNext() && reader.nextTag() != 8) {
            String tagName = reader.getLocalName();
            if (!reader.isStartElement()) {
                if (!reader.isEndElement() || !tagName.equals(parentElement.getName())) continue;
                break;
            }
            if (!tagName.equals(parentElement.getName())) {
                ModelElement element = ModelElement.forName(tagName);
                if (element != null) {
                    parser.parse(reader, element, parentNode, addOperations);
                } else if (XMLElement.forName(tagName) != null) {
                    if (visited.contains(tagName)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)tagName);
                    }
                } else {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            visited.add(tagName);
        }
    }

    static interface ElementParser {
        public void parse(XMLExtendedStreamReader var1, ModelElement var2, ModelNode var3, List<ModelNode> var4) throws XMLStreamException;
    }
}

